/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.OutputStream;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;

public class PostLh3Encoder
implements PostLzssEncoder {
    private static final int DictionarySize = 8192;
    private static final int MaxMatch = 256;
    private static final int Threshold = 3;
    private static final int[] ConstOffHiLen = PostLh3Encoder.createConstOffHiLen();
    private static final int CodeSize = 286;
    private BitOutputStream out;
    private byte[] buffer;
    private int blockSize;
    private int position;
    private int flagBit;
    private int flagPos;
    private int[] codeFreq;
    private int[] offHiFreq;

    private PostLh3Encoder() {
    }

    public PostLh3Encoder(OutputStream out) {
        this(out, 16384);
    }

    public PostLh3Encoder(OutputStream out, int BufferSize) {
        int DictionarySizeByteLen = 2;
        int MinCapacity = 25;
        if (out == null || 25 > BufferSize) {
            if (out == null) {
                throw new NullPointerException("out");
            }
            throw new IllegalArgumentException("BufferSize too small. BufferSize must be larger than 25");
        }
        this.out = out instanceof BitOutputStream ? (BitOutputStream)out : new BitOutputStream(out);
        this.codeFreq = new int[286];
        this.offHiFreq = new int[128];
        this.buffer = new byte[BufferSize];
        this.blockSize = 0;
        this.position = 0;
        this.flagBit = 0;
        this.flagPos = 0;
    }

    public void writeCode(int code) throws IOException {
        int CodeMax = 285;
        int DictionarySizeByteLen = 2;
        int Capacity = 25;
        if (this.flagBit == 0) {
            if (this.buffer.length - this.position < 25 || 65528 <= this.blockSize) {
                this.writeOut();
            }
            this.flagBit = 128;
            this.flagPos = this.position++;
            this.buffer[this.flagPos] = 0;
        }
        this.buffer[this.position++] = (byte)code;
        if (256 <= code) {
            int n = this.flagPos;
            this.buffer[n] = (byte)(this.buffer[n] | this.flagBit);
        }
        this.flagBit >>= 1;
        int n = Math.min(code, 285);
        this.codeFreq[n] = this.codeFreq[n] + 1;
        ++this.blockSize;
    }

    public void writeOffset(int offset) {
        this.buffer[this.position++] = (byte)(offset >> 8);
        this.buffer[this.position++] = (byte)offset;
        int n = offset >> 6;
        this.offHiFreq[n] = this.offHiFreq[n] + 1;
    }

    public void flush() throws IOException {
        this.writeOut();
        this.out.flush();
    }

    public void close() throws IOException {
        this.writeOut();
        this.out.close();
        this.out = null;
        this.buffer = null;
        this.codeFreq = null;
        this.offHiFreq = null;
    }

    public int getDictionarySize() {
        return 8192;
    }

    public int getMaxMatch() {
        return 256;
    }

    public int getThreshold() {
        return 3;
    }

    private void writeOut() throws IOException {
        int CodeMax = 285;
        if (this.blockSize > 0) {
            this.out.writeBits(16, this.blockSize);
            int[] codeLen = StaticHuffman.FreqListToLenList(this.codeFreq);
            int[] codeCode = StaticHuffman.LenListToCodeList(codeLen);
            int[] offHiLen = PostLh3Encoder.getBetterOffHiLen(this.offHiFreq, StaticHuffman.FreqListToLenList(this.offHiFreq));
            int[] offHiCode = StaticHuffman.LenListToCodeList(offHiLen);
            if (2 <= PostLh3Encoder.countNoZeroElement(this.codeFreq)) {
                this.writeCodeLenList(codeLen);
            } else {
                this.out.writeBits(15, 16912);
                this.out.writeBits(9, PostLh3Encoder.getNoZeroElementIndex(this.codeFreq));
            }
            if (offHiLen != ConstOffHiLen) {
                this.out.writeBit(1);
                if (2 <= PostLh3Encoder.countNoZeroElement(this.offHiFreq)) {
                    this.writeOffHiLenList(offHiLen);
                } else {
                    this.out.writeBits(12, 273);
                    this.out.writeBits(7, PostLh3Encoder.getNoZeroElementIndex(this.offHiFreq));
                }
            } else {
                this.out.writeBit(0);
            }
            this.position = 0;
            this.flagBit = 0;
            int i = 0;
            while (i < this.blockSize) {
                int code;
                if (this.flagBit == 0) {
                    this.flagBit = 128;
                    ++this.position;
                    this.flagPos = this.flagPos;
                }
                if ((this.buffer[this.flagPos] & this.flagBit) == 0) {
                    code = this.buffer[this.position++] & 0xFF;
                    this.out.writeBits(codeLen[code], codeCode[code]);
                } else {
                    code = this.buffer[this.position++] & 0xFF | 0x100;
                    int offset = (this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF;
                    int offHi = offset >> 6;
                    if (code < 285) {
                        this.out.writeBits(codeLen[code], codeCode[code]);
                    } else {
                        this.out.writeBits(codeLen[285], codeCode[285]);
                        this.out.writeBits(8, code - 285);
                    }
                    this.out.writeBits(offHiLen[offHi], offHiCode[offHi]);
                    this.out.writeBits(6, offset);
                }
                this.flagBit >>= 1;
                ++i;
            }
            i = 0;
            while (i < this.codeFreq.length) {
                this.codeFreq[i] = 0;
                ++i;
            }
            i = 0;
            while (i < this.offHiFreq.length) {
                this.offHiFreq[i] = 0;
                ++i;
            }
            this.blockSize = 0;
            this.position = 0;
            this.flagBit = 0;
        }
    }

    private void writeCodeLenList(int[] codeLen) throws IOException {
        int i = 0;
        while (i < codeLen.length) {
            if (codeLen[i] > 0) {
                this.out.writeBits(5, 0x10 | codeLen[i] - 1);
            } else {
                this.out.writeBit(0);
            }
            ++i;
        }
    }

    private void writeOffHiLenList(int[] offHiLen) throws IOException {
        int i = 0;
        while (i < offHiLen.length) {
            this.out.writeBits(4, offHiLen[i]);
            ++i;
        }
    }

    private static int countNoZeroElement(int[] array) {
        int count = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private static int getNoZeroElementIndex(int[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i] != 0) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private static int[] createConstOffHiLen() {
        length = 128;
        v0 = new int[9];
        v0[0] = 2;
        v0[1] = 1;
        v0[2] = 1;
        v0[3] = 3;
        v0[4] = 6;
        v0[5] = 13;
        v0[6] = 31;
        v0[7] = 78;
        list = v0;
        offHiLen = new int[128];
        index = 0;
        len = list[index++];
        i = 0;
        ** GOTO lbl23
        {
            ++len;
            ++index;
            do {
                if (list[index] == i) continue block0;
                offHiLen[i] = len;
                ++i;
lbl23:
                // 2 sources

            } while (i < 128);
        }
        return offHiLen;
    }

    private static int[] getBetterOffHiLen(int[] OffHiFreq, int[] OffHiLen) {
        boolean detect = false;
        int i = 0;
        while (i < OffHiLen.length) {
            if (15 < OffHiLen[i]) {
                detect = true;
            }
            ++i;
        }
        if (!detect) {
            int origTotal = 1;
            int consTotal = 1;
            origTotal = 2 <= PostLh3Encoder.countNoZeroElement(OffHiFreq) ? (origTotal += 512) : (origTotal += 19);
            int i2 = 0;
            while (i2 < OffHiFreq.length) {
                origTotal += OffHiFreq[i2] * OffHiLen[i2];
                consTotal += OffHiFreq[i2] * ConstOffHiLen[i2];
                ++i2;
            }
            if (origTotal < consTotal) {
                return OffHiLen;
            }
            return ConstOffHiLen;
        }
        return ConstOffHiLen;
    }
}

