/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.entryfilters;

import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.sf.orangesignal.csv.LhaEntryFilter;
import jp.sf.orangesignal.csv.ZipEntryFilter;

public class RegexEntryNameFilter
implements ZipEntryFilter,
LhaEntryFilter {
    private final Pattern pattern;

    public RegexEntryNameFilter(String pattern) {
        this(pattern, 0);
    }

    public RegexEntryNameFilter(String pattern, boolean ignoreCase) {
        this(pattern, ignoreCase ? 2 : 0);
    }

    public RegexEntryNameFilter(String pattern, int flags) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must not be null");
        }
        this.pattern = Pattern.compile(pattern, flags);
    }

    public RegexEntryNameFilter(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must not be null");
        }
        this.pattern = pattern;
    }

    @Override
    public boolean accept(ZipEntry entry) {
        return this.pattern.matcher(entry.getName()).matches();
    }

    @Override
    public boolean accept(LhaHeader entry) {
        return this.pattern.matcher(entry.getPath()).matches();
    }
}

