/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.sf.orangesignal.csv.CsvListHandler;
import jp.sf.orangesignal.csv.handlers.CsvValueConverter;
import jp.sf.orangesignal.csv.handlers.SimpleCsvValueConverter;

public abstract class BeanListHandlerSupport<T>
implements CsvListHandler<T> {
    private Class<T> type;
    private Map<String, Format> valueParserMap = new HashMap<String, Format>();
    private Map<Object, Format> valueFormaterMap = new HashMap<Object, Format>();
    private CsvValueConverter valueConverter = new SimpleCsvValueConverter();

    protected BeanListHandlerSupport(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        this.type = type;
    }

    public Class<T> getType() {
        return this.type;
    }

    public BeanListHandlerSupport<T> valueParserMapping(Map<String, Format> valueParserMapping) {
        if (valueParserMapping == null) {
            throw new IllegalArgumentException("CSV value parser mapping must not be null");
        }
        this.valueParserMap = valueParserMapping;
        return this;
    }

    public BeanListHandlerSupport<T> valueFormaterMapping(Map<Object, Format> valueFormaterMapping) {
        if (valueFormaterMapping == null) {
            throw new IllegalArgumentException("CSV value formater mapping must not be null");
        }
        this.valueFormaterMap = valueFormaterMapping;
        return this;
    }

    public BeanListHandlerSupport<T> valueConverter(CsvValueConverter valueConverter) {
        if (valueConverter == null) {
            throw new IllegalArgumentException("CsvValueConverter must not be null");
        }
        this.valueConverter = valueConverter;
        return this;
    }

    public BeanListHandlerSupport<T> converter(CsvValueConverter converter) {
        return this.valueConverter(converter);
    }

    public CsvValueConverter getConverter() {
        return this.valueConverter;
    }

    protected void setValueParser(String field, Format parser) {
        Format _parser = this.valueParserMap.get(field);
        if (_parser != null) {
            this.valueParserMap.put(field, BeanListHandlerSupport.mergeFormatPattern(_parser, parser));
        } else {
            this.valueParserMap.put(field, parser);
        }
    }

    protected void setValueFormater(Object column, Format formater) {
        this.valueFormaterMap.put(column, formater);
    }

    protected T createBean() throws IOException {
        try {
            return this.type.newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected Map<String, Object[]> createFieldAndColumnsMap(Map<?, String> map) {
        HashMap<String, Object[]> results = new HashMap<String, Object[]>();
        for (Field f : this.type.getDeclaredFields()) {
            String fieldName = f.getName();
            ArrayList list = new ArrayList();
            for (Map.Entry<?, String> e : map.entrySet()) {
                if (!fieldName.equals(e.getValue())) continue;
                list.add(e.getKey());
            }
            if (list.size() <= 0) continue;
            results.put(fieldName, list.toArray());
        }
        return results;
    }

    protected Object stringToObject(Field field, String value) {
        Format format = this.valueParserMap.get(field.getName());
        if (format != null) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            try {
                return format.parseObject(value);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Unable to parse the %s: %s", field.getName(), value), e);
            }
        }
        return this.valueConverter.convert(value, field.getType());
    }

    protected String objectToString(Object column, Object obj) {
        Format format = this.valueFormaterMap.get(column);
        if (format != null) {
            if (obj == null) {
                return null;
            }
            return format.format(obj);
        }
        return this.valueConverter.convert(obj);
    }

    protected static Field getField(Class<?> type, String name) throws IOException {
        try {
            return type.getDeclaredField(name);
        }
        catch (SecurityException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (NoSuchFieldException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected static void setFieldValue(Object obj, Field f, Object value) throws IOException {
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        try {
            f.set(obj, value);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected static Object getFieldValue(Object obj, Field f) throws IOException {
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        try {
            return f.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private static Format mergeFormatPattern(Format format, Format ... formats) {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(BeanListHandlerSupport.getFormatPattern(format));
            for (Format fmt : formats) {
                buf.append(BeanListHandlerSupport.getFormatPattern(fmt));
            }
            Format result = (Format)format.clone();
            result.getClass().getMethod("applyPattern", String.class).invoke((Object)result, buf.toString());
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static String getFormatPattern(Format format) {
        try {
            return (String)format.getClass().getMethod("toPattern", new Class[0]).invoke((Object)format, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

