/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.handlers.BeanListHandlerSupport;

public class ColumnNameMappingBeanListHandler<T>
extends BeanListHandlerSupport<T> {
    private LinkedHashMap<String, String> nameMap = new LinkedHashMap();

    public ColumnNameMappingBeanListHandler(Class<T> type) {
        super(type);
    }

    public ColumnNameMappingBeanListHandler<T> addColumn(String column, String field) {
        return this.addColumn(column, field, null);
    }

    public ColumnNameMappingBeanListHandler<T> addColumn(String column, String field, Format format) {
        this.nameMap.put(column, field);
        if (format != null) {
            this.setValueParser(field, format);
            this.setValueFormater(column, format);
        }
        return this;
    }

    public ColumnNameMappingBeanListHandler<T> columnMapping(Map<String, String> columnMapping) {
        if (columnMapping == null) {
            throw new IllegalArgumentException("Column mapping must not be null");
        }
        this.nameMap = new LinkedHashMap<String, String>(columnMapping);
        return this;
    }

    @Override
    public List<T> load(CsvReader reader) throws IOException {
        List<String> values;
        this.prepare();
        List<String> columnNames = reader.readValues();
        if (columnNames == null) {
            throw new IOException("No header is available");
        }
        ArrayList results = new ArrayList();
        Field[] fields = this.getType().getDeclaredFields();
        Map<String, Object[]> fieldColumnsMap = this.createFieldAndColumnsMap(this.nameMap);
        while ((values = reader.readValues()) != null) {
            Object obj = this.createBean();
            for (Field f : fields) {
                Object[] columns = fieldColumnsMap.get(f.getName());
                int count = columns == null ? 0 : columns.length;
                Object o = null;
                if (count == 1) {
                    int pos = columnNames.indexOf(columns[0]);
                    if (pos != -1) {
                        o = this.stringToObject(f, values.get(pos));
                    }
                } else if (count > 1) {
                    StringBuilder sb = new StringBuilder();
                    for (Object column : columns) {
                        String s;
                        int pos = columnNames.indexOf(column);
                        if (pos == -1 || (s = values.get(pos)) == null) continue;
                        sb.append(s);
                    }
                    o = this.stringToObject(f, sb.toString());
                }
                if (o == null) continue;
                ColumnNameMappingBeanListHandler.setFieldValue(obj, f, o);
            }
            results.add(obj);
        }
        return results;
    }

    @Override
    public void save(List<T> list, CsvWriter writer) throws IOException {
        this.prepare();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.nameMap.entrySet()) {
            columnNames.add(entry.getKey());
        }
        writer.writeValues(columnNames);
        int columnCount = columnNames.size();
        for (T obj : list) {
            if (obj == null) {
                writer.writeValues(null);
                continue;
            }
            String[] values = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                String fieldName;
                String columnName = (String)columnNames.get(i);
                if (columnName == null || (fieldName = this.nameMap.get(columnName)) == null) continue;
                Field f = ColumnNameMappingBeanListHandler.getField(obj.getClass(), fieldName);
                values[i] = this.objectToString(columnName, ColumnNameMappingBeanListHandler.getFieldValue(obj, f));
            }
            writer.writeValues(Arrays.asList(values));
        }
    }

    private void prepare() {
        if (this.nameMap.size() == 0) {
            for (Field f : this.getType().getDeclaredFields()) {
                String name = f.getName();
                this.addColumn(name, name);
            }
        }
    }
}

