/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.manager;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.Format;
import java.util.List;
import java.util.zip.ZipOutputStream;
import jp.gr.java_conf.dangan.util.lha.LhaOutputStream;
import jp.sf.orangesignal.csv.Csv;
import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.handlers.ColumnPositionMappingBeanListHandler;
import jp.sf.orangesignal.csv.manager.CsvSaver;

public class CsvColumnPositionMappingBeanSaver<T>
implements CsvSaver<T> {
    private CsvConfig cfg;
    private List<T> beans;
    private ColumnPositionMappingBeanListHandler<T> handler;

    public CsvColumnPositionMappingBeanSaver(CsvConfig cfg, List<T> beans, Class<T> beanClass) {
        if (cfg == null) {
            throw new IllegalArgumentException("CsvConfig must not be null");
        }
        this.cfg = cfg;
        this.beans = beans;
        this.handler = new ColumnPositionMappingBeanListHandler<T>(beanClass);
    }

    public CsvColumnPositionMappingBeanSaver<T> column(String field) {
        this.handler.addColumn(field);
        return this;
    }

    public CsvColumnPositionMappingBeanSaver<T> column(String field, Format format) {
        this.handler.addColumn(field, format);
        return this;
    }

    public CsvColumnPositionMappingBeanSaver<T> column(int position, String field) {
        this.handler.addColumn(position, field);
        return this;
    }

    public CsvColumnPositionMappingBeanSaver<T> column(int position, String field, Format format) {
        this.handler.addColumn(position, field, format);
        return this;
    }

    @Override
    public void to(Writer writer) throws IOException {
        Csv.save(this.beans, writer, this.cfg, this.handler);
    }

    @Override
    public void to(OutputStream out, String encoding) throws IOException {
        Csv.save(this.beans, out, encoding, this.cfg, this.handler);
    }

    @Override
    public void to(OutputStream out) throws IOException {
        Csv.save(this.beans, out, this.cfg, this.handler);
    }

    @Override
    public void to(File file, String encoding) throws IOException {
        Csv.save(this.beans, file, encoding, this.cfg, this.handler);
    }

    @Override
    public void to(File file) throws IOException {
        Csv.save(this.beans, file, this.cfg, this.handler);
    }

    @Override
    public void to(LhaOutputStream out, String entryName) throws IOException {
        Csv.save(this.beans, out, this.cfg, this.handler, entryName);
    }

    @Override
    public void to(ZipOutputStream out, String entryName) throws IOException {
        Csv.save(this.beans, out, this.cfg, this.handler, entryName);
    }
}

