/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.dangan.io.BitDataBrokenException;
import jp.gr.java_conf.dangan.io.BitInputStream;
import jp.gr.java_conf.dangan.io.NotEnoughBitsException;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;

public class PreLh3Decoder
implements PreLzssDecoder {
    private static final int DictionarySize = 8192;
    private static final int MaxMatch = 256;
    private static final int Threshold = 3;
    private static final int CodeSize = 286;
    private BitInputStream in;
    private int blockSize;
    private int[] codeLen;
    private short[] codeTable;
    private int codeTableBits;
    private short[][] codeTree;
    private int[] offHiLen;
    private short[] offHiTable;
    private int offHiTableBits;
    private short[][] offHiTree;
    private int markBlockSize;
    private int[] markCodeLen;
    private short[] markCodeTable;
    private short[][] markCodeTree;
    private int[] markOffHiLen;
    private short[] markOffHiTable;
    private short[][] markOffHiTree;

    private PreLh3Decoder() {
    }

    public PreLh3Decoder(InputStream in) {
        this(in, 12, 8);
    }

    public PreLh3Decoder(InputStream in, int CodeTableBits, int OffHiTableBits) {
        if (in == null || CodeTableBits <= 0 || OffHiTableBits <= 0) {
            if (in == null) {
                throw new NullPointerException("in");
            }
            if (CodeTableBits <= 0) {
                throw new IllegalArgumentException("CodeTableBits too small. CodeTableBits must be larger than 1.");
            }
            throw new IllegalArgumentException("OffHiTableBits too small. OffHiTableBits must be larger than 1.");
        }
        this.in = in instanceof BitInputStream ? (BitInputStream)in : new BitInputStream(in);
        this.blockSize = 0;
        this.codeTableBits = CodeTableBits;
        this.offHiTableBits = OffHiTableBits;
    }

    public int readCode() throws IOException {
        int code;
        if (this.blockSize <= 0) {
            this.readBlockHead();
        }
        --this.blockSize;
        try {
            short node = this.codeTable[this.in.peekBits(this.codeTableBits)];
            if (node < 0) {
                code = ~node;
                this.in.skipBits(this.codeLen[code]);
            } else {
                this.in.skipBits(this.codeTableBits);
                while ((node = this.codeTree[this.in.readBit()][node]) >= 0) {
                }
                code = ~node;
            }
        }
        catch (NotEnoughBitsException exception) {
            int avail = exception.getAvailableBits();
            int bits = this.in.peekBits(avail);
            short node = this.codeTable[bits <<= this.codeTableBits - avail];
            if (node < 0) {
                code = ~node;
                if (this.in.skipBits(this.codeLen[code]) < this.codeLen[code]) {
                    throw new EOFException();
                }
            }
            this.in.skipBits(avail);
            throw new EOFException();
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            throw new EOFException();
        }
        int CodeMax = 285;
        if (code == 285) {
            code += this.in.readBits(8);
        }
        return code;
    }

    public int readOffset() throws IOException {
        int offHi;
        try {
            short node = this.offHiTable[this.in.peekBits(this.offHiTableBits)];
            if (node < 0) {
                offHi = ~node;
                this.in.skipBits(this.offHiLen[offHi]);
            } else {
                this.in.skipBits(this.offHiTableBits);
                while ((node = this.offHiTree[this.in.readBit()][node]) >= 0) {
                }
                offHi = ~node;
            }
        }
        catch (NotEnoughBitsException exception) {
            int avail = exception.getAvailableBits();
            int bits = this.in.peekBits(avail);
            short node = this.offHiTable[bits <<= this.offHiTableBits - avail];
            if (node < 0) {
                offHi = ~node;
                if (this.offHiLen[offHi] <= avail) {
                    this.in.skipBits(this.offHiLen[offHi]);
                }
                this.in.skipBits(avail);
                throw new EOFException();
            }
            this.in.skipBits(avail);
            throw new EOFException();
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            throw new EOFException();
        }
        return offHi << 6 | this.in.readBits(6);
    }

    public void mark(int readLimit) {
        if (this.blockSize < (readLimit = readLimit * 16 / 8)) {
            readLimit += 245;
        }
        this.in.mark(readLimit);
        this.markBlockSize = this.blockSize;
        this.markCodeLen = this.codeLen;
        this.markCodeTable = this.codeTable;
        this.markCodeTree = this.codeTree;
        this.markOffHiLen = this.offHiLen;
        this.markOffHiTable = this.offHiTable;
        this.markOffHiTree = this.offHiTree;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.blockSize = this.markBlockSize;
        this.codeLen = this.markCodeLen;
        this.codeTable = this.markCodeTable;
        this.codeTree = this.markCodeTree;
        this.offHiLen = this.markOffHiLen;
        this.offHiTable = this.markOffHiTable;
        this.offHiTree = this.markOffHiTree;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int available() throws IOException {
        int avail = this.in.available() * 8 / 16;
        if (this.blockSize < avail) {
            avail -= 245;
        }
        return Math.max(avail, 0);
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.blockSize = 0;
        this.codeLen = null;
        this.codeTable = null;
        this.codeTree = null;
        this.offHiLen = null;
        this.offHiTable = null;
        this.offHiTree = null;
        this.markBlockSize = 0;
        this.markCodeLen = null;
        this.markCodeTable = null;
        this.markCodeTree = null;
        this.markOffHiLen = null;
        this.markOffHiTable = null;
        this.markOffHiTree = null;
    }

    public int getDictionarySize() {
        return 8192;
    }

    public int getMaxMatch() {
        return 256;
    }

    public int getThreshold() {
        return 3;
    }

    private void readBlockHead() throws IOException {
        int i;
        try {
            this.blockSize = this.in.readBits(16);
        }
        catch (BitDataBrokenException exception) {
            if (exception.getCause() instanceof EOFException) {
                throw (EOFException)exception.getCause();
            }
            throw exception;
        }
        this.codeLen = this.readCodeLen();
        if (1 < this.codeLen.length) {
            short[][] tableAndTree = StaticHuffman.createTableAndTree(this.codeLen, this.codeTableBits);
            this.codeTable = tableAndTree[0];
            this.codeTree = new short[][]{tableAndTree[1], tableAndTree[2]};
        } else {
            int code = this.codeLen[0];
            this.codeLen = new int[286];
            this.codeTable = new short[1 << this.codeTableBits];
            i = 0;
            while (i < this.codeTable.length) {
                this.codeTable[i] = (short)(~code);
                ++i;
            }
            this.codeTree = new short[][]{new short[0], new short[0]};
        }
        this.offHiLen = this.readOffHiLen();
        if (1 < this.offHiLen.length) {
            short[][] tableAndTree = StaticHuffman.createTableAndTree(this.offHiLen, this.offHiTableBits);
            this.offHiTable = tableAndTree[0];
            this.offHiTree = new short[][]{tableAndTree[1], tableAndTree[2]};
        } else {
            int offHi = this.offHiLen[0];
            this.offHiLen = new int[128];
            this.offHiTable = new short[1 << this.offHiTableBits];
            i = 0;
            while (i < this.offHiTable.length) {
                this.offHiTable[i] = (short)(~offHi);
                ++i;
            }
            this.offHiTree = new short[][]{new short[0], new short[0]};
        }
    }

    private int[] readCodeLen() throws IOException {
        int[] codeLen = new int[286];
        int i = 0;
        while (i < codeLen.length) {
            if (this.in.readBoolean()) {
                codeLen[i] = this.in.readBits(4) + 1;
            }
            if (i == 2 && codeLen[0] == 1 && codeLen[1] == 1 && codeLen[2] == 1) {
                return new int[]{this.in.readBits(9)};
            }
            ++i;
        }
        return codeLen;
    }

    private int[] readOffHiLen() throws IOException {
        if (this.in.readBoolean()) {
            int[] offHiLen = new int[128];
            int i = 0;
            while (i < offHiLen.length) {
                offHiLen[i] = this.in.readBits(4);
                if (i == 2 && offHiLen[0] == 1 && offHiLen[1] == 1 && offHiLen[2] == 1) {
                    return new int[]{this.in.readBits(7)};
                }
                ++i;
            }
            return offHiLen;
        }
        return PreLh3Decoder.createConstOffHiLen();
    }

    /*
     * Unable to fully structure code
     */
    private static int[] createConstOffHiLen() {
        length = 128;
        v0 = new int[9];
        v0[0] = 2;
        v0[1] = 1;
        v0[2] = 1;
        v0[3] = 3;
        v0[4] = 6;
        v0[5] = 13;
        v0[6] = 31;
        v0[7] = 78;
        list = v0;
        LenList = new int[128];
        index = 0;
        len = list[index++];
        i = 0;
        ** GOTO lbl23
        {
            ++len;
            ++index;
            do {
                if (list[index] == i) continue block0;
                LenList[i] = len;
                ++i;
lbl23:
                // 2 sources

            } while (i < 128);
        }
        return LenList;
    }
}

