/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.CsvToken;
import jp.sf.orangesignal.csv.SimpleCsvToken;

public class CsvReader
implements Closeable {
    private Reader in;
    private CsvConfig cfg;
    private String line;
    private int nextChar = -1;
    private int pos;
    private boolean skiped;
    private int startTokenLineNumber = 0;
    private int endTokenLineNumber = 0;
    private int startLineNumber = 0;
    private int endLineNumber = 0;
    private int lineNumber = 0;
    private boolean endOfFile;
    private boolean endOfLine;
    private boolean cr = false;
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static int defaultCharBufferSize = 8192;

    public CsvReader(Reader in, int sz, CsvConfig cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException("CsvConfig must not be null");
        }
        cfg.validate();
        this.in = new BufferedReader(in, sz);
        this.cfg = cfg;
    }

    public CsvReader(Reader in, CsvConfig cfg) {
        this(in, defaultCharBufferSize, cfg);
    }

    public CsvReader(Reader in, int sz) {
        this(in, sz, new CsvConfig());
    }

    public CsvReader(Reader in) {
        this(in, defaultCharBufferSize, new CsvConfig());
    }

    public int getStartLineNumber() {
        return this.startLineNumber;
    }

    public int getEndLineNumber() {
        return this.endLineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private String cacheLine() throws IOException {
        int c;
        StringBuilder buf = new StringBuilder();
        if (this.nextChar != -1) {
            c = this.nextChar;
            this.nextChar = -1;
        } else {
            c = this.in.read();
        }
        int i = -1;
        while (c != -1) {
            buf.append((char)c);
            if (c == 13) {
                i = buf.length();
                this.nextChar = this.in.read();
                if (this.nextChar != 10) break;
                buf.append((char)this.nextChar);
                this.nextChar = -1;
                break;
            }
            if (c == 10) {
                i = buf.length();
                break;
            }
            c = this.in.read();
        }
        this.line = buf.toString();
        this.pos = 0;
        if (i != -1) {
            return buf.substring(0, i - 1);
        }
        return this.line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read() throws IOException {
        Reader reader = this.in;
        synchronized (reader) {
            this.ensureOpen();
            if (this.endOfFile) {
                return -1;
            }
            if (this.line == null || this.line.length() <= this.pos) {
                this.cacheLine();
            }
            if (this.line.length() == 0) {
                return -1;
            }
            return this.line.charAt(this.pos++);
        }
    }

    public List<String> readValues() throws IOException {
        List<CsvToken> tokens = this.readTokens();
        if (tokens == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>(tokens.size());
        for (CsvToken token : tokens) {
            results.add(token.getValue());
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CsvToken> readTokens() throws IOException {
        Reader reader = this.in;
        synchronized (reader) {
            this.ensureOpen();
            if (this.endOfFile) {
                return null;
            }
            if (!this.skiped) {
                for (int i = 0; i < this.cfg.getSkipLines(); ++i) {
                    this.cacheLine();
                    ++this.endTokenLineNumber;
                    ++this.lineNumber;
                }
                this.line = null;
                this.skiped = true;
            }
            return this.readCsvTokens();
        }
    }

    private List<CsvToken> readCsvTokens() throws IOException {
        ArrayList<CsvToken> results = new ArrayList<CsvToken>();
        ++this.endTokenLineNumber;
        this.startLineNumber = this.endTokenLineNumber;
        this.endOfLine = false;
        do {
            if (this.line == null || this.line.length() <= this.pos) {
                boolean ignore;
                String _line = this.cacheLine();
                if (this.cfg.isIgnoreEmptyLines()) {
                    ignore = true;
                    while (ignore && this.line.length() > 0) {
                        ignore = false;
                        if (!CsvReader.isWhitespaces(_line)) continue;
                        ignore = true;
                        this.startLineNumber = ++this.endTokenLineNumber;
                        ++this.lineNumber;
                        _line = this.cacheLine();
                    }
                }
                if (this.cfg.getIgnoreLinePatterns() != null) {
                    ignore = true;
                    block2: while (ignore && this.line.length() > 0) {
                        ignore = false;
                        for (Pattern p : this.cfg.getIgnoreLinePatterns()) {
                            if (p == null || !p.matcher(_line).matches()) continue;
                            ignore = true;
                            this.startLineNumber = ++this.endTokenLineNumber;
                            ++this.lineNumber;
                            _line = this.cacheLine();
                            continue block2;
                        }
                    }
                }
            }
            this.startTokenLineNumber = this.endTokenLineNumber;
            results.add(this.readCsvToken());
        } while (!this.endOfLine);
        this.endLineNumber = this.endTokenLineNumber;
        ++this.lineNumber;
        if (this.cfg.isIgnoreEmptyLines() && (this.line.isEmpty() || CsvReader.isWhitespaces(this.line)) && results.size() == 1) {
            return null;
        }
        return results;
    }

    private CsvToken readCsvToken() throws IOException {
        StringBuilder buf = new StringBuilder();
        boolean inQuote = false;
        boolean enclosed = false;
        boolean escaped = false;
        boolean _escaped = false;
        this.endTokenLineNumber = this.startTokenLineNumber;
        while (true) {
            int c = this.read();
            if (this.cr) {
                this.cr = false;
                escaped = false;
                if (c == 10) {
                    if (!inQuote) continue;
                    buf.append((char)c);
                    continue;
                }
            } else if (_escaped && c == this.cfg.getSeparator()) {
                buf.append((char)c);
                _escaped = false;
                continue;
            }
            _escaped = false;
            if (c == -1) {
                this.endOfLine = true;
                this.endOfFile = true;
                break;
            }
            if (!inQuote) {
                if (c == this.cfg.getSeparator()) break;
                if (c == 13) {
                    this.endOfLine = true;
                    this.cr = true;
                    break;
                }
                if (c == 10) {
                    this.endOfLine = true;
                    break;
                }
                if (!this.cfg.isQuoteDisabled() && !enclosed && c == this.cfg.getQuote()) {
                    if (CsvReader.isWhitespaces(buf)) {
                        inQuote = true;
                    }
                } else if (this.cfg.isQuoteDisabled() && !this.cfg.isEscapeDisabled() && c == this.cfg.getEscape()) {
                    _escaped = true;
                }
            } else {
                if (escaped && !this.cfg.isQuoteDisabled() && !this.cfg.isEscapeDisabled() && this.cfg.getQuote() == this.cfg.getEscape()) {
                    if (c == this.cfg.getSeparator()) break;
                    if (c == 13) {
                        this.endOfLine = true;
                        this.cr = true;
                        break;
                    }
                    if (c == 10) {
                        this.endOfLine = true;
                        break;
                    }
                }
                if (c == this.cfg.getQuote()) {
                    if (escaped) {
                        escaped = false;
                    } else {
                        inQuote = false;
                        enclosed = true;
                    }
                } else if (c == 13) {
                    this.cr = true;
                    ++this.endTokenLineNumber;
                } else if (c == 10) {
                    ++this.endTokenLineNumber;
                }
                escaped = !this.cfg.isEscapeDisabled() && c == this.cfg.getEscape();
            }
            buf.append((char)c);
        }
        if (escaped) {
            enclosed = true;
        }
        String value = buf.toString();
        if (enclosed) {
            int i = value.lastIndexOf(this.cfg.getQuote()) + 1;
            assert (i > 0);
            if (i < value.length() && !CsvReader.isWhitespaces(value.substring(i + 1))) {
                enclosed = false;
            }
        }
        if (this.cfg.isIgnoreLeadingWhitespaces() || enclosed) {
            value = CsvReader.removeLeadingWhitespaces(value);
        }
        if (this.cfg.isIgnoreTrailingWhitespaces() || enclosed) {
            value = CsvReader.removeTrailingWhitespaces(value);
        }
        if (enclosed) {
            value = value.substring(1, value.length() - 1);
            if (this.cfg.getBreakString() != null) {
                value = value.replaceAll("\r\n|\r|\n", this.cfg.getBreakString());
            }
            if (!this.cfg.isEscapeDisabled()) {
                value = this.unescapeQuote(value);
            }
        } else {
            if (this.cfg.getNullString() != null) {
                if (this.cfg.isIgnoreCaseNullString()) {
                    if (this.cfg.getNullString().equalsIgnoreCase(value)) {
                        value = null;
                    }
                } else if (this.cfg.getNullString().equals(value)) {
                    value = null;
                }
            }
            if (value != null && !this.cfg.isEscapeDisabled()) {
                value = this.unescapeSeparator(value);
            }
        }
        return new SimpleCsvToken(value, this.startTokenLineNumber, this.endTokenLineNumber, enclosed);
    }

    private String unescapeQuote(String value) {
        return value.replace(new StringBuilder(2).append(this.cfg.getEscape()).append(this.cfg.getQuote()), new StringBuilder(1).append(this.cfg.getQuote()));
    }

    private String unescapeSeparator(String value) {
        return value.replace(new StringBuilder(2).append(this.cfg.getEscape()).append(this.cfg.getSeparator()), new StringBuilder(1).append(this.cfg.getSeparator()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Reader reader = this.in;
        synchronized (reader) {
            if (this.in != null) {
                this.in.close();
                this.in = null;
                this.cfg = null;
                this.line = null;
            }
        }
    }

    private static boolean isWhitespaces(CharSequence value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String removeLeadingWhitespaces(String value) {
        int len = value.length();
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            pos = i;
            break;
        }
        if (pos > 0) {
            return value.substring(pos);
        }
        return value;
    }

    private static String removeTrailingWhitespaces(String value) {
        int start;
        int pos = start = value.length() - 1;
        for (int i = start; i >= 0; --i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            pos = i;
            break;
        }
        if (pos != start) {
            return value.substring(0, pos + 1);
        }
        return value;
    }
}

