/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.entryfilters;

import java.util.Collection;
import java.util.zip.ZipEntry;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.sf.orangesignal.csv.LhaEntryFilter;
import jp.sf.orangesignal.csv.ZipEntryFilter;

public class EntryNameFilter
implements ZipEntryFilter,
LhaEntryFilter {
    private String[] names;
    private boolean ignoreCase;

    public EntryNameFilter(String name) {
        this(new String[]{name}, false);
    }

    public EntryNameFilter(String name, boolean ignoreCase) {
        this(new String[]{name}, ignoreCase);
    }

    public EntryNameFilter(String[] names) {
        this(names, false);
    }

    public EntryNameFilter(String[] names, boolean ignoreCase) {
        if (names == null) {
            throw new IllegalArgumentException("Names must not be null");
        }
        this.names = names;
        this.ignoreCase = ignoreCase;
    }

    public EntryNameFilter(Collection<String> names) {
        this(names, false);
    }

    public EntryNameFilter(Collection<String> names, boolean ignoreCase) {
        if (names == null) {
            throw new IllegalArgumentException("Names must not be null");
        }
        this.names = names.toArray(new String[0]);
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean accept(ZipEntry entry) {
        return this.accept(entry.getName());
    }

    @Override
    public boolean accept(LhaHeader entry) {
        return this.accept(entry.getPath());
    }

    private boolean accept(String path) {
        for (String name : this.names) {
            boolean b;
            boolean bl = b = this.ignoreCase ? path.equalsIgnoreCase(name) : path.equals(name);
            if (!b) continue;
            return true;
        }
        return false;
    }
}

