/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.annotation.CsvColumn;
import jp.sf.orangesignal.csv.annotation.CsvEntity;
import jp.sf.orangesignal.csv.handlers.BeanListHandlerSupport;

public class CsvEntityListHandler<T>
extends BeanListHandlerSupport<T> {
    public CsvEntityListHandler(Class<T> entityClass) {
        super(entityClass);
        if (entityClass.getAnnotation(CsvEntity.class) == null) {
            throw new IllegalArgumentException(String.format("No CsvEntity is available %s", entityClass.getName()));
        }
    }

    @Override
    public List<T> load(CsvReader reader) throws IOException {
        List<String> values;
        if (reader == null) {
            throw new IllegalArgumentException("CsvReader must not be null");
        }
        List<String> names = !this.getType().getAnnotation(CsvEntity.class).header() ? null : reader.readValues();
        ArrayList results = new ArrayList();
        Field[] fields = this.getType().getDeclaredFields();
        int offset = 0;
        while ((values = reader.readValues()) != null && (this.getLimit() <= 0 || results.size() < this.getLimit())) {
            if (offset < this.getOffset()) {
                ++offset;
                continue;
            }
            Object obj = this.createBean();
            for (Field f : fields) {
                CsvColumn column = f.getAnnotation(CsvColumn.class);
                if (column == null) continue;
                int pos = column.position();
                if (pos < 0 && names != null) {
                    pos = names.indexOf(CsvEntityListHandler.defaultIfEmpty(column.name(), f.getName()));
                }
                if (pos == -1) {
                    throw new IOException(String.format("Invalid CsvColumn field %s", f.getName()));
                }
                Object o = this.stringToObject(f, values.get(pos));
                if (o == null) continue;
                CsvEntityListHandler.setFieldValue(obj, f, o);
            }
            results.add(obj);
        }
        return results;
    }

    @Override
    public void save(List<T> entities, CsvWriter writer) throws IOException {
        if (entities == null) {
            throw new IllegalArgumentException("CsvEntities must not be null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("CsvWriter must not be null");
        }
        List<String> names = CsvEntityListHandler.getColumnNames(this.getType());
        if (this.getType().getAnnotation(CsvEntity.class).header()) {
            writer.writeValues(names);
        }
        int columnCount = names.size();
        for (T entity : entities) {
            if (entity == null || entity.getClass().getAnnotation(CsvEntity.class) == null) {
                writer.writeValues(null);
                continue;
            }
            String[] values = new String[columnCount];
            for (Field f : entity.getClass().getDeclaredFields()) {
                CsvColumn column = f.getAnnotation(CsvColumn.class);
                if (column == null) continue;
                int pos = column.position();
                if (pos < 0) {
                    pos = names.indexOf(CsvEntityListHandler.defaultIfEmpty(column.name(), f.getName()));
                }
                if (pos == -1) {
                    throw new IOException(String.format("Invalid CsvColumn field %s", f.getName()));
                }
                values[pos] = this.objectToString(names.get(pos), CsvEntityListHandler.getFieldValue(entity, f));
            }
            writer.writeValues(Arrays.asList(values));
        }
    }

    private static List<String> getColumnNames(Class<?> entityClass) {
        TreeMap<Integer, String> positionMap = new TreeMap<Integer, String>();
        ArrayList<String> adding = new ArrayList<String>();
        for (Field field : entityClass.getDeclaredFields()) {
            CsvColumn column = field.getAnnotation(CsvColumn.class);
            if (column == null) continue;
            int pos = column.position();
            String name = CsvEntityListHandler.defaultIfEmpty(column.name(), field.getName());
            if (pos >= 0) {
                if (positionMap.containsKey(pos)) continue;
                positionMap.put(pos, name);
                continue;
            }
            adding.add(name);
        }
        int max = positionMap.size() > 0 ? (Integer)positionMap.lastKey() + 1 : 0;
        String[] names = new String[max];
        for (Map.Entry entry : positionMap.entrySet()) {
            names[((Integer)entry.getKey()).intValue()] = (String)entry.getValue();
        }
        ArrayList<String> results = new ArrayList<String>(Arrays.asList(names));
        if (adding.size() > 0) {
            results.addAll(adding);
        }
        return results;
    }

    private static String defaultIfEmpty(String str, String defaultStr) {
        return str == null || str.isEmpty() ? defaultStr : str;
    }
}

