/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import jp.sf.orangesignal.csv.CsvHandler;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvResultSet;
import jp.sf.orangesignal.csv.CsvWriter;

public class ResultSetHandler
implements CsvHandler<ResultSet> {
    @Override
    public ResultSet load(CsvReader reader) throws IOException {
        return new CsvResultSet(reader);
    }

    @Override
    public void save(ResultSet rs, CsvWriter writer) throws IOException {
        try {
            int count = ResultSetHandler.writeHeader(rs.getMetaData(), writer);
            while (rs.next()) {
                ArrayList<String> list = new ArrayList<String>(count);
                for (int i = 1; i <= count; ++i) {
                    Object o = rs.getObject(i);
                    if (rs.wasNull()) {
                        list.add(null);
                        continue;
                    }
                    list.add(o.toString());
                }
                writer.writeValues(list);
            }
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private static int writeHeader(ResultSetMetaData meta, CsvWriter writer) throws IOException {
        try {
            int count = meta.getColumnCount();
            ArrayList<String> list = new ArrayList<String>(count);
            for (int i = 1; i <= count; ++i) {
                list.add(meta.getColumnLabel(i));
            }
            writer.writeValues(list);
            return count;
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

