/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import jp.gr.java_conf.dangan.lang.reflect.Factory;

public class LhaProperty {
    private static final Properties property = LhaProperty.createLhaProperty();
    public static final String encoding = property.getProperty("lha.encoding");

    private LhaProperty() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getProperty(String key) {
        String def = property.getProperty(key);
        try {
            if (key.equals("lha.encoding") && System.getProperty(key, def).equals("ShiftJISAuto")) {
                try {
                    String encoding = System.getProperty("file.encoding");
                    if (LhaProperty.isCategoryOfShiftJIS(encoding)) {
                        return encoding;
                    }
                    return "SJIS";
                }
                catch (SecurityException exception) {
                    return "SJIS";
                }
            }
            return System.getProperty(key, def);
        }
        catch (SecurityException securityException) {
            return def;
        }
    }

    public static Properties getProperties() {
        Properties property = (Properties)LhaProperty.property.clone();
        Enumeration<?> enumkey = property.propertyNames();
        while (enumkey.hasMoreElements()) {
            String key = (String)enumkey.nextElement();
            try {
                String val = System.getProperty(key);
                if (val == null) continue;
                property.put(key, val);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (property.getProperty("lha.encoding").equals("ShiftJISAuto")) {
            try {
                String encoding = System.getProperty("file.encoding");
                if (LhaProperty.isCategoryOfShiftJIS(encoding)) {
                    property.put("lha.encoding", encoding);
                } else {
                    property.put("lha.encoding", "SJIS");
                }
            }
            catch (SecurityException exception) {
                property.put("lha.encoding", "SJIS");
            }
        }
        return property;
    }

    public static Object parse(String source, Hashtable substitute, String packages) {
        StringTokenizer tokenizer = new StringTokenizer(packages, ",");
        String[] packageArray = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            packageArray[i++] = tokenizer.nextToken().trim();
        }
        return LhaProperty.parse(source, substitute, packageArray);
    }

    public static Object parse(String source, Hashtable substitute, String[] packages) {
        source = source.trim();
        int casearcpos = source.indexOf("(");
        int bracepos = source.indexOf("[");
        if (casearcpos >= 0 && (bracepos < 0 || casearcpos < bracepos)) {
            return LhaProperty.parseConstructor(source, substitute, packages);
        }
        if (bracepos >= 0 && (casearcpos < 0 || bracepos < casearcpos)) {
            return LhaProperty.parseArray(source, substitute, packages);
        }
        if (substitute.containsKey(source)) {
            return substitute.get(source);
        }
        return LhaProperty.applyPackages(source, packages);
    }

    private static Object parseConstructor(String source, Hashtable substitute, String[] packages) {
        Object[] args;
        String classname = source.substring(0, source.indexOf(40)).trim();
        String arguments = source.substring(source.indexOf(40) + 1, source.lastIndexOf(41)).trim();
        classname = LhaProperty.applyPackages(classname, packages);
        if (!arguments.equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(arguments, ",()[]", true);
            Stack<Object> stack = new Stack<Object>();
            int pos = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("(")) {
                    stack.push("(");
                } else if (token.equals(")")) {
                    if (!stack.empty() && stack.peek().equals("(")) {
                        stack.pop();
                    }
                } else if (token.equals("[")) {
                    stack.push("[");
                } else if (token.equals("]")) {
                    if (!stack.empty() && stack.peek().equals("[")) {
                        stack.pop();
                    }
                } else if (token.equals(",") && (stack.empty() || !stack.peek().equals("(") && !stack.peek().equals("["))) {
                    stack.push(new Integer(pos));
                }
                pos += token.length();
            }
            pos = 0;
            args = new Object[stack.size() + 1];
            int i = 0;
            while (i < stack.size() + 1) {
                String arg = i < stack.size() ? arguments.substring(pos, (Integer)stack.elementAt(i)) : arguments.substring(pos);
                pos += arg.length() + 1;
                args[i] = LhaProperty.parse(arg, substitute, packages);
                ++i;
            }
        } else {
            args = new Object[]{};
        }
        try {
            return Factory.createInstance(classname, args);
        }
        catch (InstantiationException exception) {
            throw new InstantiationError(exception.getMessage());
        }
        catch (InvocationTargetException exception) {
            if (exception.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)exception.getTargetException();
            }
            if (exception.getTargetException() instanceof Error) {
                throw (Error)exception.getTargetException();
            }
            throw new Error(exception.getTargetException().getMessage());
        }
        catch (ClassNotFoundException exception) {
            throw new NoClassDefFoundError(exception.getMessage());
        }
        catch (NoSuchMethodException exception) {
            throw new NoSuchMethodError(exception.getMessage());
        }
    }

    private static Object[] parseArray(String source, Hashtable substitute, String[] packages) {
        String arguments = source.substring(source.indexOf(91) + 1, source.lastIndexOf(93)).trim();
        if (!arguments.equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(arguments, ",()[]", true);
            Stack<Object> stack = new Stack<Object>();
            int pos = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("(")) {
                    stack.push("(");
                } else if (token.equals(")")) {
                    if (!stack.empty() && stack.peek().equals("(")) {
                        stack.pop();
                    }
                } else if (token.equals("[")) {
                    stack.push("[");
                } else if (token.equals("]")) {
                    if (!stack.empty() && stack.peek().equals("[")) {
                        stack.pop();
                    }
                } else if (token.equals(",") && (stack.empty() || !stack.peek().equals("(") && !stack.peek().equals("["))) {
                    stack.push(new Integer(pos));
                }
                pos += token.length();
            }
            pos = 0;
            Object[] array = new Object[stack.size() + 1];
            int i = 0;
            while (i < stack.size() + 1) {
                String arg = i < stack.size() ? arguments.substring(pos, (Integer)stack.elementAt(i)) : arguments.substring(pos);
                pos += arg.length() + 1;
                array[i] = LhaProperty.parse(arg, substitute, packages);
                ++i;
            }
            return array;
        }
        return new Object[0];
    }

    private static String applyPackages(String str, String[] packages) {
        int i = 0;
        while (i < packages.length) {
            String classname = packages[i].equals("") ? str : String.valueOf(packages[i]) + "." + str;
            try {
                Class.forName(classname);
                return classname;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            ++i;
        }
        return str;
    }

    private static final Properties createLhaProperty() {
        String path = "jp.gr.java_conf.dangan.util.lha.resources.lha";
        Properties property = LhaProperty.createDefaultProperty();
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(path);
            Enumeration<String> enumkey = bundle.getKeys();
            while (enumkey.hasMoreElements()) {
                String key = enumkey.nextElement();
                property.put(key, bundle.getString(key));
            }
        }
        catch (MissingResourceException bundle) {
            // empty catch block
        }
        if (property.getProperty("lha.encoding").equals("ShiftJISAuto")) {
            try {
                String encoding = System.getProperty("file.encoding");
                if (LhaProperty.isCategoryOfShiftJIS(encoding)) {
                    property.put("lha.encoding", encoding);
                } else {
                    property.put("lha.encoding", "SJIS");
                }
            }
            catch (SecurityException exception) {
                property.put("lha.encoding", "SJIS");
            }
        }
        return property;
    }

    private static final Properties createDefaultProperty() {
        Properties property = new Properties();
        property.put("lha.encoding", LhaProperty.getSystemEncoding());
        property.put("lha.packages", "jp.gr.java_conf.dangan.util.lha");
        property.put("lha.lzs.encoder", "LzssOutputStream( PostLzsEncoder( out ), HashAndChainedListSearch, [ HashShort ] )");
        property.put("lha.lz4.encoder", "out");
        property.put("lha.lz5.encoder", "LzssOutputStream( PostLz5Encoder( out ), HashAndChainedListSearch )");
        property.put("lha.lhd.encoder", "out");
        property.put("lha.lh0.encoder", "out");
        property.put("lha.lh1.encoder", "LzssOutputStream( PostLh1Encoder( out ), HashAndChainedListSearch )");
        property.put("lha.lh2.encoder", "LzssOutputStream( PostLh2Encoder( out ), HashAndChainedListSearch )");
        property.put("lha.lh3.encoder", "LzssOutputStream( PostLh3Encoder( out ), HashAndChainedListSearch )");
        property.put("lha.lh4.encoder", "LzssOutputStream( PostLh5Encoder( out, -lh4- ), HashAndChainedListSearch )");
        property.put("lha.lh5.encoder", "LzssOutputStream( PostLh5Encoder( out, -lh5- ), HashAndChainedListSearch )");
        property.put("lha.lh6.encoder", "LzssOutputStream( PostLh5Encoder( out, -lh6- ), HashAndChainedListSearch )");
        property.put("lha.lh7.encoder", "LzssOutputStream( PostLh5Encoder( out, -lh7- ), HashAndChainedListSearch )");
        property.put("lha.lzs.decoder", "LzssInputStream( PreLzsDecoder( in ), length )");
        property.put("lha.lz4.decoder", "in");
        property.put("lha.lz5.decoder", "LzssInputStream( PreLz5Decoder( in ), length )");
        property.put("lha.lhd.decoder", "in");
        property.put("lha.lh0.decoder", "in");
        property.put("lha.lh1.decoder", "LzssInputStream( PreLh1Decoder( in ), length )");
        property.put("lha.lh2.decoder", "LzssInputStream( PreLh2Decoder( in ), length )");
        property.put("lha.lh3.decoder", "LzssInputStream( PreLh3Decoder( in ), length )");
        property.put("lha.lh4.decoder", "LzssInputStream( PreLh5Decoder( in, -lh4- ), length )");
        property.put("lha.lh5.decoder", "LzssInputStream( PreLh5Decoder( in, -lh5- ), length )");
        property.put("lha.lh6.decoder", "LzssInputStream( PreLh5Decoder( in, -lh6- ), length )");
        property.put("lha.lh7.decoder", "LzssInputStream( PreLh5Decoder( in, -lh7- ), length )");
        property.put("lha.header", "LhaHeader( data, encoding )");
        return property;
    }

    private static final String getSystemEncoding() {
        String encoding;
        block3: {
            try {
                encoding = System.getProperty("file.encoding");
                if (!LhaProperty.isJapanese(encoding) || LhaProperty.isCategoryOfShiftJIS(encoding)) break block3;
                return "SJIS";
            }
            catch (SecurityException exception) {
                encoding = "ISO8859_1";
                return encoding;
            }
        }
        return encoding;
    }

    private static final boolean isJapanese(String encoding) {
        String[] Coverters = new String[]{"Cp930", "Cp939", "Cp942", "Cp942C", "Cp943", "Cp943C", "Cp33722", "MS932", "SJIS", "EUC_JP", "ISO2022JP", "JIS0201", "JIS0208", "JIS0212", "JISAutoDetect"};
        int i = 0;
        while (i < Coverters.length) {
            if (encoding.equals(Coverters[i])) {
                return true;
            }
            ++i;
        }
        String[] Aliases = new String[]{"eucjis", "euc-jp", "eucjp", "x-euc-jp", "x-eucjp", "csEUCPkdFmtJapanese", "extended_unix_code_packed_format_for_japanese ", "shift_jis", "ms_kanji", "csShiftJIS", "csWindows31J", "windows-31j", "x-sjis", "jis", "iso-2022-jp", "csISO2022JP", "jis_encoding", "csJISEncoding", "jis auto detect", "cp930", "ibm-930", "ibm930", "930", "cp939", "ibm-939", "ibm939", "939", "cp942", "ibm-942", "ibm942", "942", "cp942c", "cp943", "ibm-943", "ibm943", "943", "cp943c", "cp33722", "ibm-33722", "ibm33722", "33722"};
        int i2 = 0;
        while (i2 < Aliases.length) {
            if (encoding.equalsIgnoreCase(Aliases[i2])) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private static final boolean isCategoryOfShiftJIS(String encoding) {
        String[] Coverters = new String[]{"Cp942", "Cp942C", "Cp943", "Cp943C", "MS932", "SJIS"};
        int i = 0;
        while (i < Coverters.length) {
            if (encoding.equals(Coverters[i])) {
                return true;
            }
            ++i;
        }
        String[] Aliases = new String[]{"shift_jis", "ms_kanji", "csShiftJIS", "csWindows31J", "windows-31j", "x-sjis", "cp942", "ibm-942", "ibm942", "942", "cp942c", "cp943", "ibm-943", "ibm943", "943", "cp943c"};
        int i2 = 0;
        while (i2 < Aliases.length) {
            if (encoding.equalsIgnoreCase(Aliases[i2])) {
                return true;
            }
            ++i2;
        }
        return false;
    }
}

