/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 *
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 *
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import jp.sf.orangesignal.csv.CsvListHandler;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;

/**
 * 文字列配列のリストで区切り文字形式データアクセスを行うハンドラを提供します。
 *
 * @author 杉澤 浩二
 */
public class StringArrayListHandler implements CsvListHandler<String[]> {

	/**
	 * デフォルトコンストラクタです。
	 */
	public StringArrayListHandler() {}

	@Override
	public List<String[]> load(final CsvReader reader) throws IOException {
		final List<String[]> results = new ArrayList<String[]>();
		List<String> tokens;
		while ((tokens = reader.readValues()) != null) {
			results.add(tokens.toArray(new String[0]));
		}
		return results;
	}

	@Override
	public void save(final List<String[]> list, final CsvWriter writer) throws IOException {
		for (final String[] values : list) {
			writer.writeValues(Arrays.asList(values));
		}
	}

}
