/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jp.sf.orangesignal.csv.CsvListHandler;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;

public class ColumnPositionMapListHandler
implements CsvListHandler<Map<Integer, String>> {
    private int offset;
    private int limit;

    public ColumnPositionMapListHandler offset(int offset) {
        this.offset = offset;
        return this;
    }

    public ColumnPositionMapListHandler limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public List<Map<Integer, String>> load(CsvReader reader) throws IOException {
        List<String> values;
        ArrayList<Map<Integer, String>> results = new ArrayList<Map<Integer, String>>();
        int offset = 0;
        while ((values = reader.readValues()) != null && (this.limit <= 0 || results.size() < this.limit)) {
            if (offset < this.offset) {
                ++offset;
                continue;
            }
            TreeMap<Integer, String> map = new TreeMap<Integer, String>();
            int len = values.size();
            for (int pos = 0; pos < len; ++pos) {
                map.put(pos, values.get(pos));
            }
            results.add(map);
        }
        return results;
    }

    @Override
    public void save(List<Map<Integer, String>> list, CsvWriter writer) throws IOException {
        for (Map<Integer, String> map : list) {
            if (map == null) {
                writer.writeValues(null);
                continue;
            }
            String[] values = new String[ColumnPositionMapListHandler.getMaxColumnPosition(map) + 1];
            for (Map.Entry<Integer, String> e : map.entrySet()) {
                int pos = e.getKey();
                if (pos < 0) continue;
                values[pos] = e.getValue();
            }
            writer.writeValues(Arrays.asList(values));
        }
    }

    private static int getMaxColumnPosition(Map<Integer, String> map) {
        TreeMap<Integer, String> m = map instanceof SortedMap ? (TreeMap<Integer, String>)map : new TreeMap<Integer, String>(map);
        return Math.max((Integer)m.lastKey(), 0);
    }
}

