/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.sf.orangesignal.csv.CsvListHandler;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;

public class StringArrayListHandler
implements CsvListHandler<String[]> {
    private int offset;
    private int limit;

    public StringArrayListHandler offset(int offset) {
        this.offset = offset;
        return this;
    }

    public StringArrayListHandler limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public List<String[]> load(CsvReader reader) throws IOException {
        List<String> values;
        ArrayList<String[]> results = new ArrayList<String[]>();
        int offset = 0;
        while ((values = reader.readValues()) != null && (this.limit <= 0 || results.size() < this.limit)) {
            if (offset < this.offset) {
                ++offset;
                continue;
            }
            results.add(values.toArray(new String[0]));
        }
        return results;
    }

    @Override
    public void save(List<String[]> list, CsvWriter writer) throws IOException {
        for (String[] values : list) {
            writer.writeValues(Arrays.asList(values));
        }
    }
}

