/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 *
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 *
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.csv.manager;

import java.text.Format;

import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.handlers.ColumnNameMappingBeanListHandler;

/**
 * 区切り文字形式データの項目名を基準とする Java プログラム要素のリストと区切り文字形式データの統合入力インタフェースの実装クラスを提供します。
 *
 * @author 杉澤 浩二
 * @since 1.2
 */
public class CsvColumnNameMappingBeanLoader<T> extends CsvLoaderSupport<T> {

	/**
	 * データアクセスハンドラを保持します。
	 */
	private ColumnNameMappingBeanListHandler<T> handler;

	/**
	 * コンストラクタです。
	 *
	 * @param cfg 区切り文字形式情報
	 * @param beanClass JavaBean の型
	 * @throws IllegalArgumentException パラメータが不正な場合
	 */
	public CsvColumnNameMappingBeanLoader(final CsvConfig cfg, final Class<T> beanClass) {
		super(cfg);
		this.handler = new ColumnNameMappingBeanListHandler<T>(beanClass);
	}

	/**
	 * 指定された項目名と Java プログラム要素のフィールド名をマップへ追加します。
	 * 
	 * @param column 項目名
	 * @param field Java プログラム要素のフィールド名
	 * @return このオブジェクトへの参照
	 */
	public CsvColumnNameMappingBeanLoader<T> column(final String column, final String field) {
		handler.addColumn(column, field);
		return this;
	}

	/**
	 * 指定された項目名と Java プログラム要素のフィールド名をマップへ追加します。
	 * 
	 * @param column 項目名
	 * @param field Java プログラム要素のフィールド名
	 * @param format フィールドを処理するフォーマットオブジェクト (オプション)
	 * @return このオブジェクトへの参照
	 * @since 1.2
	 */
	public CsvColumnNameMappingBeanLoader<T> column(final String column, final String field, final Format format) {
		handler.addColumn(column, field, format);
		return this;
	}

	/**
	 * 取得データの開始位置を設定します。
	 * 
	 * @param offset 取得データの開始位置
	 * @return このオブジェクトへの参照
	 * @since 1.2.1
	 */
	public CsvColumnNameMappingBeanLoader<T> offset(final int offset) {
		handler.offset(offset);
		return this;
	}

	/**
	 * 取得データの限度数を設定します。
	 * 
	 * @param limit 取得データの限度数
	 * @return このオブジェクトへの参照
	 * @since 1.2.1
	 */
	public CsvColumnNameMappingBeanLoader<T> limit(final int limit) {
		handler.limit(limit);
		return this;
	}

	@Override protected ColumnNameMappingBeanListHandler<T> getCsvListHandler() { return handler; }

}
