/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.filters;

import java.io.IOException;
import java.util.Comparator;
import java.util.regex.Pattern;
import jp.sf.orangesignal.csv.filters.BeanAndExpression;
import jp.sf.orangesignal.csv.filters.BeanExpressions;
import jp.sf.orangesignal.csv.filters.BeanFilter;
import jp.sf.orangesignal.csv.filters.BeanLogicalExpression;

public class SimpleBeanFilter
implements BeanFilter {
    private BeanLogicalExpression expr;

    public SimpleBeanFilter() {
        this(new BeanAndExpression());
    }

    public SimpleBeanFilter(BeanLogicalExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("%s must not be null", BeanLogicalExpression.class.getSimpleName()));
        }
        this.expr = expr;
    }

    public SimpleBeanFilter add(BeanFilter filter) {
        this.expr.add(filter);
        return this;
    }

    public SimpleBeanFilter isNull(String name) {
        this.expr.add(BeanExpressions.isNull(name));
        return this;
    }

    public SimpleBeanFilter isNotNull(String name) {
        this.expr.add(BeanExpressions.isNotNull(name));
        return this;
    }

    public SimpleBeanFilter isEmpty(String name) {
        this.expr.add(BeanExpressions.isEmpty(name));
        return this;
    }

    public SimpleBeanFilter isNotEmpty(String name) {
        this.expr.add(BeanExpressions.isNotEmpty(name));
        return this;
    }

    public SimpleBeanFilter eq(String name, Object criteria) {
        this.expr.add(BeanExpressions.eq(name, criteria));
        return this;
    }

    public SimpleBeanFilter eq(String name, String criteria, boolean ignoreCase) {
        this.expr.add(BeanExpressions.eq(name, criteria, ignoreCase));
        return this;
    }

    public SimpleBeanFilter ne(String name, Object criteria) {
        this.expr.add(BeanExpressions.ne(name, criteria));
        return this;
    }

    public SimpleBeanFilter ne(String name, String criteria, boolean ignoreCase) {
        this.expr.add(BeanExpressions.ne(name, criteria, ignoreCase));
        return this;
    }

    public SimpleBeanFilter in(String name, Object ... criterias) {
        this.expr.add(BeanExpressions.in(name, criterias));
        return this;
    }

    public SimpleBeanFilter in(String name, String[] criterias) {
        this.expr.add(BeanExpressions.in(name, criterias));
        return this;
    }

    public SimpleBeanFilter in(String name, String[] criterias, boolean ignoreCase) {
        this.expr.add(BeanExpressions.in(name, criterias, ignoreCase));
        return this;
    }

    public SimpleBeanFilter notIn(String name, Object ... criterias) {
        this.expr.add(BeanExpressions.notIn(name, criterias));
        return this;
    }

    public SimpleBeanFilter notIn(String name, String[] criterias) {
        this.expr.add(BeanExpressions.notIn(name, criterias));
        return this;
    }

    public SimpleBeanFilter notIn(String name, String[] criterias, boolean ignoreCase) {
        this.expr.add(BeanExpressions.notIn(name, criterias, ignoreCase));
        return this;
    }

    public SimpleBeanFilter regex(String name, String pattern) {
        this.expr.add(BeanExpressions.regex(name, pattern));
        return this;
    }

    public SimpleBeanFilter regex(String name, String pattern, boolean ignoreCase) {
        this.expr.add(BeanExpressions.regex(name, pattern, ignoreCase));
        return this;
    }

    public SimpleBeanFilter regex(String name, String pattern, int flags) {
        this.expr.add(BeanExpressions.regex(name, pattern, flags));
        return this;
    }

    public SimpleBeanFilter regex(String name, Pattern pattern) {
        this.expr.add(BeanExpressions.regex(name, pattern));
        return this;
    }

    public SimpleBeanFilter gt(String name, Object criteria) {
        this.expr.add(BeanExpressions.gt(name, criteria));
        return this;
    }

    public SimpleBeanFilter gt(String name, Object criteria, Comparator comparator) {
        this.expr.add(BeanExpressions.gt(name, criteria, comparator));
        return this;
    }

    public SimpleBeanFilter lt(String name, Object criteria) {
        this.expr.add(BeanExpressions.lt(name, criteria));
        return this;
    }

    public SimpleBeanFilter lt(String name, Object criteria, Comparator comparator) {
        this.expr.add(BeanExpressions.lt(name, criteria, comparator));
        return this;
    }

    public SimpleBeanFilter ge(String name, Object criteria) {
        this.expr.add(BeanExpressions.ge(name, criteria));
        return this;
    }

    public SimpleBeanFilter ge(String name, Object criteria, Comparator comparator) {
        this.expr.add(BeanExpressions.ge(name, criteria, comparator));
        return this;
    }

    public SimpleBeanFilter le(String name, Object criteria) {
        this.expr.add(BeanExpressions.le(name, criteria));
        return this;
    }

    public SimpleBeanFilter le(String name, Object criteria, Comparator comparator) {
        this.expr.add(BeanExpressions.le(name, criteria, comparator));
        return this;
    }

    public SimpleBeanFilter between(String name, Object low, Object high) {
        this.expr.add(BeanExpressions.between(name, low, high));
        return this;
    }

    public SimpleBeanFilter between(String name, Object low, Object high, Comparator comparator) {
        this.expr.add(BeanExpressions.between(name, low, high, comparator));
        return this;
    }

    public SimpleBeanFilter not(BeanFilter filter) {
        this.expr.add(BeanExpressions.not(filter));
        return this;
    }

    @Override
    public boolean accept(Object bean) throws IOException {
        return this.expr.accept(bean);
    }

    public String toString() {
        String name = this.getClass().getName();
        int period = name.lastIndexOf(46);
        return period > 0 ? name.substring(period + 1) : name;
    }
}

