/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.filters.CsvValueFilter;
import jp.sf.orangesignal.csv.handlers.BeanListHandlerSupport;

public class ColumnPositionMappingBeanListHandler<T>
extends BeanListHandlerSupport<T, ColumnPositionMappingBeanListHandler<T>> {
    private SortedMap<Integer, String> positionMap = new TreeMap<Integer, String>();
    private CsvValueFilter valueFilter;
    private boolean useHeader = true;

    public ColumnPositionMappingBeanListHandler(Class<T> type) {
        super(type);
    }

    public ColumnPositionMappingBeanListHandler<T> addColumn(String field) {
        return this.addColumn(field, null);
    }

    public ColumnPositionMappingBeanListHandler<T> addColumn(String field, Format format) {
        return this.addColumn(this.getMaxColumnPosition() + 1, field, format);
    }

    public ColumnPositionMappingBeanListHandler<T> addColumn(int position, String field) {
        return this.addColumn(position, field, null);
    }

    public ColumnPositionMappingBeanListHandler<T> addColumn(int position, String field, Format format) {
        this.positionMap.put(position, field);
        if (format != null) {
            this.setValueParser(field, format);
            this.setValueFormatter(position, format);
        }
        return this;
    }

    public ColumnPositionMappingBeanListHandler<T> columnMapping(Map<Integer, String> columnMapping) {
        if (columnMapping == null) {
            throw new IllegalArgumentException("Column mapping must not be null");
        }
        this.positionMap = new TreeMap<Integer, String>(columnMapping);
        return this;
    }

    public ColumnPositionMappingBeanListHandler<T> filter(CsvValueFilter filter) {
        this.valueFilter = filter;
        return this;
    }

    private int getMaxColumnPosition() {
        if (this.positionMap.size() > 0) {
            return this.positionMap.lastKey();
        }
        return -1;
    }

    @Override
    public List<T> load(CsvReader reader) throws IOException {
        List<String> values;
        if (this.positionMap.size() == 0) {
            List<String> columnNames = reader.readValues();
            if (columnNames == null) {
                throw new IOException("No header is available");
            }
            for (String name : columnNames) {
                this.addColumn(name);
            }
        }
        ArrayList results = new ArrayList();
        Field[] fields = this.getType().getDeclaredFields();
        Map<String, Object[]> fieldColumnsMap = this.createFieldAndColumnsMap(this.positionMap);
        int offset = 0;
        while ((values = reader.readValues()) != null && (this.limit <= 0 || results.size() < this.limit)) {
            if (this.valueFilter != null && !this.valueFilter.accept(values)) continue;
            if (this.beanFilter == null && offset < this.offset) {
                ++offset;
                continue;
            }
            Object bean = this.createBean();
            for (Field f : fields) {
                Object[] columns = fieldColumnsMap.get(f.getName());
                int count = columns == null ? 0 : columns.length;
                Object o = null;
                if (count == 1) {
                    int pos = (Integer)columns[0];
                    if (pos >= 0) {
                        o = this.stringToObject(f, values.get(pos));
                    }
                } else if (count > 1) {
                    StringBuilder sb = new StringBuilder();
                    for (Object column : columns) {
                        String s;
                        int pos = (Integer)column;
                        if (pos < 0 || (s = values.get(pos)) == null) continue;
                        sb.append(s);
                    }
                    o = this.stringToObject(f, sb.toString());
                }
                if (o == null) continue;
                ColumnPositionMappingBeanListHandler.setFieldValue(bean, f, o);
            }
            if (this.beanFilter != null) {
                if (!this.beanFilter.accept(bean)) continue;
                if (offset < this.offset) {
                    ++offset;
                    continue;
                }
            }
            results.add(bean);
        }
        return results;
    }

    @Override
    public void save(List<T> list, CsvWriter writer) throws IOException {
        if (this.positionMap.size() == 0) {
            for (Field f : this.getType().getDeclaredFields()) {
                this.addColumn(f.getName());
            }
        }
        int columnCount = this.getMaxColumnPosition() + 1;
        if (this.useHeader) {
            String[] names = new String[columnCount];
            for (Map.Entry<Integer, String> e : this.positionMap.entrySet()) {
                names[e.getKey().intValue()] = e.getValue();
            }
            writer.writeValues(Arrays.asList(names));
        }
        for (T bean : list) {
            if (bean == null) {
                writer.writeValues(null);
                continue;
            }
            if (this.beanFilter != null && !this.beanFilter.accept(bean)) continue;
            Class<?> type = bean.getClass();
            String[] values = new String[columnCount];
            for (Map.Entry<Integer, String> e : this.positionMap.entrySet()) {
                int pos = e.getKey();
                if (pos == -1) continue;
                Field f = ColumnPositionMappingBeanListHandler.getField(type, e.getValue());
                values[pos] = this.objectToString(pos, ColumnPositionMappingBeanListHandler.getFieldValue(bean, f));
            }
            List<String> _values = Arrays.asList(values);
            if (this.valueFilter != null && !this.valueFilter.accept(_values)) continue;
            writer.writeValues(_values);
        }
    }
}

