/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.sf.orangesignal.csv.CsvListHandler;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.filters.CsvValueFilter;

public class StringArrayListHandler
implements CsvListHandler<String[]> {
    private CsvValueFilter valueFilter;
    private int offset;
    private int limit;

    public StringArrayListHandler filter(CsvValueFilter filter) {
        this.valueFilter = filter;
        return this;
    }

    public StringArrayListHandler offset(int offset) {
        this.offset = offset;
        return this;
    }

    public StringArrayListHandler limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public List<String[]> load(CsvReader reader) throws IOException {
        List<String> values;
        ArrayList<String[]> results = new ArrayList<String[]>();
        int offset = 0;
        while ((values = reader.readValues()) != null && (this.limit <= 0 || results.size() < this.limit)) {
            if (this.valueFilter != null && !this.valueFilter.accept(values)) continue;
            if (offset < this.offset) {
                ++offset;
                continue;
            }
            results.add(values.toArray(new String[0]));
        }
        return results;
    }

    @Override
    public void save(List<String[]> list, CsvWriter writer) throws IOException {
        for (String[] values : list) {
            List<String> _values = Arrays.asList(values);
            if (this.valueFilter != null && !this.valueFilter.accept(_values)) continue;
            writer.writeValues(_values);
        }
    }
}

