/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.entryfilters;

import java.util.Collection;
import java.util.zip.ZipEntry;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.sf.orangesignal.csv.entryfilters.AbstractEntryFilter;

public class SuffixEntryNameFilter
extends AbstractEntryFilter {
    private static final long serialVersionUID = -2053518605167417363L;
    private String[] suffixes;
    private boolean ignoreCase;

    public SuffixEntryNameFilter(String suffix) {
        this(new String[]{suffix}, false);
    }

    public SuffixEntryNameFilter(String suffix, boolean ignoreCase) {
        this(new String[]{suffix}, ignoreCase);
    }

    public SuffixEntryNameFilter(String[] suffixes) {
        this(suffixes, false);
    }

    public SuffixEntryNameFilter(String[] suffixes, boolean ignoreCase) {
        if (suffixes == null) {
            throw new IllegalArgumentException("Suffixes must not be null");
        }
        this.suffixes = suffixes;
        this.ignoreCase = ignoreCase;
    }

    public SuffixEntryNameFilter(Collection<String> suffixes) {
        this(suffixes, false);
    }

    public SuffixEntryNameFilter(Collection<String> suffixes, boolean ignoreCase) {
        if (suffixes == null) {
            throw new IllegalArgumentException("Suffixes must not be null");
        }
        this.suffixes = suffixes.toArray(new String[0]);
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean accept(ZipEntry entry) {
        return this.accept(entry.getName());
    }

    @Override
    public boolean accept(LhaHeader entry) {
        return this.accept(entry.getPath());
    }

    private boolean accept(String path) {
        String[] stringArray = this.suffixes;
        int n = this.suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            int len = suffix.length();
            boolean b = path.regionMatches(this.ignoreCase, path.length() - len, suffix, 0, len);
            if (b) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append('(');
        if (this.suffixes != null) {
            int length = this.suffixes.length;
            int i = 0;
            while (i < length) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.suffixes[i]);
                ++i;
            }
        }
        sb.append(')');
        return sb.toString();
    }
}

