/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.filters;

import java.util.List;
import java.util.regex.Pattern;

abstract class CsvExpressionUtils {
    protected CsvExpressionUtils() {
    }

    public static boolean isNull(List<String> values, int position) {
        CsvExpressionUtils.validate(values, position);
        return values.get(position) == null;
    }

    public static boolean isNotNull(List<String> values, int position) {
        return !CsvExpressionUtils.isNull(values, position);
    }

    public static boolean isEmpty(List<String> values, int position) {
        CsvExpressionUtils.validate(values, position);
        String value = values.get(position);
        return value == null || value.isEmpty();
    }

    public static boolean isNotEmpty(List<String> values, int position) {
        return !CsvExpressionUtils.isEmpty(values, position);
    }

    public static boolean eq(List<String> values, int position, String criteria, boolean ignoreCase) {
        CsvExpressionUtils.validate(values, position);
        if (criteria == null) {
            throw new IllegalArgumentException("Criteria must not be null");
        }
        String value = values.get(position);
        return value != null && (ignoreCase ? criteria.equalsIgnoreCase(value) : criteria.equals(value));
    }

    public static boolean ne(List<String> values, int position, String criteria, boolean ignoreCase) {
        return !CsvExpressionUtils.eq(values, position, criteria, ignoreCase);
    }

    public static boolean in(List<String> values, int position, String[] criterias, boolean ignoreCase) {
        if (criterias == null) {
            throw new IllegalArgumentException("Criterias must not be null");
        }
        String[] stringArray = criterias;
        int n = criterias.length;
        int n2 = 0;
        while (n2 < n) {
            String criteria = stringArray[n2];
            if (CsvExpressionUtils.eq(values, position, criteria, ignoreCase)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean notIn(List<String> values, int position, String[] criterias, boolean ignoreCase) {
        return !CsvExpressionUtils.in(values, position, criterias, ignoreCase);
    }

    public static boolean regex(List<String> values, int position, Pattern pattern) {
        CsvExpressionUtils.validate(values, position);
        String value = values.get(position);
        return value != null && pattern.matcher(value).matches();
    }

    public static boolean gt(List<String> values, int position, String criteria) {
        CsvExpressionUtils.validate(values, position);
        String value = values.get(position);
        return value != null && criteria != null && value.compareTo(criteria) > 0;
    }

    public static boolean lt(List<String> values, int position, String criteria) {
        CsvExpressionUtils.validate(values, position);
        String value = values.get(position);
        return value != null && criteria != null && value.compareTo(criteria) < 0;
    }

    public static boolean ge(List<String> values, int position, String criteria) {
        CsvExpressionUtils.validate(values, position);
        String value = values.get(position);
        return value != null && criteria != null && value.compareTo(criteria) >= 0;
    }

    public static boolean le(List<String> values, int position, String criteria) {
        CsvExpressionUtils.validate(values, position);
        String value = values.get(position);
        return value != null && criteria != null && value.compareTo(criteria) <= 0;
    }

    public static boolean between(List<String> values, int position, String low, String high) {
        return CsvExpressionUtils.ge(values, position, low) && CsvExpressionUtils.le(values, position, high);
    }

    protected static void validate(List<String> values, int position) {
        if (values == null) {
            throw new IllegalArgumentException("Values must not be null");
        }
        if (position < 0 || position >= values.size()) {
            throw new IllegalArgumentException(String.format("Invalid column position %d", position));
        }
    }
}

