/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sf.orangesignal.csv.CsvListHandler;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.filters.CsvNamedValueFilter;

public class ColumnNameMapListHandler
implements CsvListHandler<Map<String, String>> {
    private List<String> columnNames;
    private CsvNamedValueFilter valueFilter;
    private int offset;
    private int limit;

    public ColumnNameMapListHandler addColumn(String columnName) {
        if (this.columnNames == null) {
            this.columnNames = new ArrayList<String>();
        }
        this.columnNames.add(columnName);
        return this;
    }

    public ColumnNameMapListHandler columnNames(Collection<String> columnNames) {
        this.columnNames = new ArrayList<String>(columnNames);
        return this;
    }

    public ColumnNameMapListHandler filter(CsvNamedValueFilter filter) {
        this.valueFilter = filter;
        return this;
    }

    public ColumnNameMapListHandler offset(int offset) {
        this.offset = offset;
        return this;
    }

    public ColumnNameMapListHandler limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public List<Map<String, String>> load(CsvReader reader) throws IOException {
        List<String> values;
        if (this.columnNames == null) {
            this.columnNames = reader.readValues();
            if (this.columnNames == null) {
                throw new IOException("No header is available");
            }
        }
        int columnCount = this.columnNames.size();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(columnCount);
        for (String columnName : this.columnNames) {
            m.put(columnName, null);
        }
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        int offset = 0;
        while ((values = reader.readValues()) != null && (this.limit <= 0 || results.size() < this.limit)) {
            if (this.valueFilter != null && !this.valueFilter.accept(this.columnNames, values)) continue;
            if (offset < this.offset) {
                ++offset;
                continue;
            }
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(m);
            int len = Math.min(columnCount, values.size());
            int pos = 0;
            while (pos < len) {
                map.put(this.columnNames.get(pos), values.get(pos));
                ++pos;
            }
            results.add(map);
        }
        return results;
    }

    @Override
    public void save(List<Map<String, String>> list, CsvWriter writer) throws IOException {
        if (this.columnNames == null) {
            for (Map<String, String> map : list) {
                if (map == null) continue;
                this.columnNames = new ArrayList<String>(map.keySet());
                break;
            }
        }
        if (this.columnNames == null) {
            throw new IOException("No header is available");
        }
        writer.writeValues(this.columnNames);
        int columnCount = this.columnNames.size();
        for (Map<String, String> map : list) {
            if (map == null) {
                writer.writeValues(null);
                continue;
            }
            String[] values = new String[columnCount];
            int i = 0;
            while (i < columnCount) {
                values[i] = map.get(this.columnNames.get(i));
                ++i;
            }
            List<String> _values = Arrays.asList(values);
            if (this.valueFilter != null && !this.valueFilter.accept(this.columnNames, _values)) continue;
            writer.writeValues(_values);
        }
    }
}

