/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.filters.CsvNamedValueFilter;
import jp.sf.orangesignal.csv.handlers.BeanListHandlerSupport;

public class ColumnNameMappingBeanListHandler<T>
extends BeanListHandlerSupport<T, ColumnNameMappingBeanListHandler<T>> {
    private LinkedHashMap<String, String> columnMapping = new LinkedHashMap();
    private CsvNamedValueFilter valueFilter;

    public ColumnNameMappingBeanListHandler(Class<T> type) {
        super(type);
    }

    public ColumnNameMappingBeanListHandler<T> addColumn(String column, String field) {
        return this.addColumn(column, field, null);
    }

    public ColumnNameMappingBeanListHandler<T> addColumn(String column, String field, Format format) {
        this.columnMapping.put(column, field);
        if (format != null) {
            this.setValueParser(field, format);
            this.setValueFormatter(column, format);
        }
        return this;
    }

    public void setColumnMapping(Map<String, String> columnMapping) {
        if (columnMapping == null) {
            throw new IllegalArgumentException("Column mapping must not be null");
        }
        this.columnMapping = new LinkedHashMap<String, String>(columnMapping);
    }

    public ColumnNameMappingBeanListHandler<T> columnMapping(Map<String, String> columnMapping) {
        this.setColumnMapping(columnMapping);
        return this;
    }

    public ColumnNameMappingBeanListHandler<T> filter(CsvNamedValueFilter filter) {
        this.valueFilter = filter;
        return this;
    }

    @Override
    public List<T> load(CsvReader reader) throws IOException {
        List<String> values;
        this.prepare();
        List<String> columnNames = reader.readValues();
        if (columnNames == null) {
            throw new IOException("No header is available");
        }
        ArrayList results = new ArrayList();
        Field[] fields = this.getType().getDeclaredFields();
        Map<String, Object[]> fieldColumnsMap = this.createFieldAndColumnsMap(this.columnMapping);
        int offset = 0;
        while ((values = reader.readValues()) != null && (this.limit <= 0 || results.size() < this.limit)) {
            if (this.valueFilter != null && !this.valueFilter.accept(columnNames, values)) continue;
            if (this.beanFilter == null && offset < this.offset) {
                ++offset;
                continue;
            }
            Object bean = this.createBean();
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                Object[] columns = fieldColumnsMap.get(f.getName());
                int count = columns == null ? 0 : columns.length;
                Object o = null;
                if (count == 1) {
                    int pos = columnNames.indexOf(columns[0]);
                    if (pos != -1) {
                        o = this.stringToObject(f, values.get(pos));
                    }
                } else if (count > 1) {
                    StringBuilder sb = new StringBuilder();
                    Object[] objectArray = columns;
                    int n3 = columns.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s;
                        Object column = objectArray[n4];
                        int pos = columnNames.indexOf(column);
                        if (pos != -1 && (s = values.get(pos)) != null) {
                            sb.append(s);
                        }
                        ++n4;
                    }
                    o = this.stringToObject(f, sb.toString());
                }
                if (o != null) {
                    ColumnNameMappingBeanListHandler.setFieldValue(bean, f, o);
                }
                ++n2;
            }
            if (this.beanFilter != null) {
                if (!this.beanFilter.accept(bean)) continue;
                if (offset < this.offset) {
                    ++offset;
                    continue;
                }
            }
            results.add(bean);
        }
        return results;
    }

    @Override
    public void save(List<T> list, CsvWriter writer) throws IOException {
        this.prepare();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.columnMapping.entrySet()) {
            columnNames.add(entry.getKey());
        }
        writer.writeValues(columnNames);
        int columnCount = columnNames.size();
        for (T bean : list) {
            if (bean == null) {
                writer.writeValues(null);
                continue;
            }
            if (this.beanFilter != null && !this.beanFilter.accept(bean)) continue;
            String[] values = new String[columnCount];
            int i = 0;
            while (i < columnCount) {
                String fieldName;
                String columnName = (String)columnNames.get(i);
                if (columnName != null && (fieldName = this.columnMapping.get(columnName)) != null) {
                    Field f = ColumnNameMappingBeanListHandler.getField(bean.getClass(), fieldName);
                    values[i] = this.objectToString(columnName, ColumnNameMappingBeanListHandler.getFieldValue(bean, f));
                }
                ++i;
            }
            List<String> _values = Arrays.asList(values);
            if (this.valueFilter != null && !this.valueFilter.accept(columnNames, _values)) continue;
            writer.writeValues(_values);
        }
    }

    private void prepare() {
        if (this.columnMapping.size() == 0) {
            Field[] fieldArray = this.getType().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                String name = f.getName();
                this.addColumn(name, name);
                ++n2;
            }
        }
    }
}

