/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.lang.reflect.InvocationTargetException;
import jp.gr.java_conf.dangan.lang.reflect.Factory;
import jp.gr.java_conf.dangan.util.lha.HashDefault;
import jp.gr.java_conf.dangan.util.lha.HashMethod;
import jp.gr.java_conf.dangan.util.lha.LzssOutputStream;
import jp.gr.java_conf.dangan.util.lha.LzssSearchMethod;

public class HashAndChainedListSearch
implements LzssSearchMethod {
    private int DictionarySize;
    private int MaxMatch;
    private int Threshold;
    private byte[] TextBuffer;
    private int DictionaryLimit;
    private HashMethod hashMethod;
    private int[] hashTable;
    private char[] tooBigFlag;
    private int[] prev;
    private int SearchLimitCount;

    private HashAndChainedListSearch() {
    }

    public HashAndChainedListSearch(int DictionarySize, int MaxMatch, int Threshold, byte[] TextBuffer) {
        this(DictionarySize, MaxMatch, Threshold, TextBuffer, HashDefault.class.getName(), 256);
    }

    public HashAndChainedListSearch(int DictionarySize, int MaxMatch, int Threshold, byte[] TextBuffer, int SearchLimitCount) {
        this(DictionarySize, MaxMatch, Threshold, TextBuffer, HashDefault.class.getName(), SearchLimitCount);
    }

    public HashAndChainedListSearch(int DictionarySize, int MaxMatch, int Threshold, byte[] TextBuffer, String HashMethodClassName) {
        this(DictionarySize, MaxMatch, Threshold, TextBuffer, HashMethodClassName, 256);
    }

    public HashAndChainedListSearch(int DictionarySize, int MaxMatch, int Threshold, byte[] TextBuffer, String HashMethodClassName, int SearchLimitCount) {
        if (SearchLimitCount > 0) {
            this.DictionarySize = DictionarySize;
            this.MaxMatch = MaxMatch;
            this.Threshold = Threshold;
            this.TextBuffer = TextBuffer;
            this.DictionaryLimit = this.DictionarySize;
            this.SearchLimitCount = SearchLimitCount;
            try {
                this.hashMethod = (HashMethod)Factory.createInstance(HashMethodClassName, new Object[]{TextBuffer});
            }
            catch (ClassNotFoundException exception) {
                throw new NoClassDefFoundError(exception.getMessage());
            }
            catch (InvocationTargetException exception) {
                throw new Error(exception.getTargetException().getMessage());
            }
            catch (NoSuchMethodException exception) {
                throw new NoSuchMethodError(exception.getMessage());
            }
            catch (InstantiationException exception) {
                throw new InstantiationError(exception.getMessage());
            }
            this.hashTable = new int[this.hashMethod.tableSize()];
            int i = 0;
            while (i < this.hashTable.length) {
                this.hashTable[i] = -1;
                ++i;
            }
            this.prev = new int[this.DictionarySize];
            i = 0;
            while (i < this.prev.length) {
                this.prev[i] = -1;
                ++i;
            }
        } else {
            throw new IllegalArgumentException("SearchLimitCount must be 1 or more.");
        }
        this.tooBigFlag = new char[this.hashMethod.tableSize() >> 4];
    }

    public void put(int position) {
        int hash = this.hashMethod.hash(position);
        this.prev[position & this.DictionarySize - 1] = this.hashTable[hash];
        this.hashTable[hash] = position;
    }

    public int searchAndPut(int position) {
        int poshash;
        int matchlen = this.Threshold - 1;
        int matchpos = position;
        int maxmatch = this.MaxMatch;
        int scanlimit = Math.max(this.DictionaryLimit, position - this.DictionarySize);
        int offhash = poshash = this.hashMethod.hash(position);
        int offset = 0;
        while (this.isTooBig(offhash) && offset < this.MaxMatch - this.hashMethod.hashRequires()) {
            offhash = this.hashMethod.hash(position + ++offset);
        }
        byte[] buf = this.TextBuffer;
        int max = position + this.MaxMatch;
        int s = 0;
        int p = 0;
        int len = 0;
        while (true) {
            int scanpos = this.hashTable[offhash];
            int searchCount = this.SearchLimitCount;
            while (scanlimit <= scanpos - offset && --searchCount > 0) {
                if (buf[scanpos + matchlen - offset] == buf[position + matchlen]) {
                    s = scanpos - offset;
                    p = position;
                    while (buf[s] == buf[p]) {
                        ++s;
                        if (max <= ++p) break;
                    }
                    if (matchlen < (len = p - position)) {
                        matchpos = scanpos - offset;
                        matchlen = len;
                        if (max <= p) break;
                    }
                }
                scanpos = this.prev[scanpos & this.DictionarySize - 1];
            }
            if (searchCount <= 0) {
                this.setTooBigFlag(offhash);
            } else if (scanpos < scanlimit) {
                this.clearTooBigFlag(offhash);
            }
            if (offset <= 0 || matchlen >= this.hashMethod.hashRequires() + offset) break;
            offset = 0;
            maxmatch = this.hashMethod.hashRequires() + offset - 1;
            max = position + maxmatch;
            offhash = poshash;
        }
        this.prev[position & this.DictionarySize - 1] = this.hashTable[poshash];
        this.hashTable[poshash] = position;
        if (this.Threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    public int search(int position, int lastPutPos) {
        int matchlen = this.Threshold - 1;
        int matchpos = position;
        int scanpos = position - 1;
        int scanlimit = Math.max(this.DictionaryLimit, lastPutPos);
        byte[] buf = this.TextBuffer;
        int max = Math.min(this.TextBuffer.length, position + this.MaxMatch);
        int s = 0;
        int p = 0;
        int len = 0;
        while (scanlimit < scanpos) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max <= ++p) break;
            }
            if (matchlen < len) {
                matchpos = scanpos;
                matchlen = len;
            }
            --scanpos;
        }
        if (this.hashMethod.hashRequires() < this.TextBuffer.length - position) {
            int poshash;
            int maxmatch = this.MaxMatch;
            scanlimit = Math.max(this.DictionaryLimit, position - this.DictionarySize);
            int offhash = poshash = this.hashMethod.hash(position);
            int offset = 0;
            while (this.isTooBig(offhash) && offset < this.MaxMatch - this.hashMethod.hashRequires()) {
                offhash = this.hashMethod.hash(position + ++offset);
            }
            while (true) {
                int searchCount = this.SearchLimitCount;
                scanpos = this.hashTable[offhash];
                while (scanlimit <= scanpos - offset && --searchCount > 0) {
                    if (buf[scanpos + matchlen - offset] == buf[position + matchlen]) {
                        s = scanpos - offset;
                        p = position;
                        while (buf[s] == buf[p]) {
                            ++s;
                            if (max <= ++p) break;
                        }
                        if (matchlen < (len = p - position)) {
                            matchpos = scanpos - offset;
                            matchlen = len;
                            if (max <= p) break;
                        }
                    }
                    scanpos = this.prev[scanpos & this.DictionarySize - 1];
                }
                if (searchCount <= 0) {
                    this.setTooBigFlag(offhash);
                } else if (scanpos < scanlimit) {
                    this.clearTooBigFlag(offhash);
                }
                if (offset <= 0 || matchlen >= this.hashMethod.hashRequires() + offset) break;
                offset = 0;
                maxmatch = this.hashMethod.hashRequires() + offset - 1;
                max = Math.min(this.TextBuffer.length, position + maxmatch);
                offhash = poshash;
            }
        }
        if (this.Threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    public void slide() {
        int pos;
        this.DictionaryLimit = Math.max(0, this.DictionaryLimit - this.DictionarySize);
        int i = 0;
        while (i < this.hashTable.length) {
            pos = this.hashTable[i] - this.DictionarySize;
            this.hashTable[i] = pos >= 0 ? pos : -1;
            ++i;
        }
        i = 0;
        while (i < this.prev.length) {
            pos = this.prev[i] - this.DictionarySize;
            this.prev[i] = pos >= 0 ? pos : -1;
            ++i;
        }
    }

    public int putRequires() {
        return this.hashMethod.hashRequires();
    }

    public int searchAndPut(int position, int[] matchposs) {
        int matchlen = this.Threshold - 1;
        int matchpos = position;
        int maxmatch = this.MaxMatch;
        int scanlimit = Math.max(this.DictionaryLimit, position - this.DictionarySize);
        int searchCount = this.SearchLimitCount;
        int i = 0;
        while (i < matchposs.length) {
            matchposs[i] = -1;
            ++i;
        }
        int scanpos = this.hashTable[this.hashMethod.hash(position)];
        while (scanlimit < scanpos && searchCount-- > 0) {
            if (this.TextBuffer[scanpos + matchlen] == this.TextBuffer[position + matchlen]) {
                int len = 0;
                while (this.TextBuffer[scanpos + len] == this.TextBuffer[position + len]) {
                    if (maxmatch <= ++len) break;
                }
                if (matchlen < len) {
                    int i2 = matchlen + 1 - this.Threshold;
                    int end = Math.min(len + 1 - this.Threshold, matchposs.length);
                    while (i2 < end) {
                        matchposs[i2++] = scanpos;
                    }
                    matchpos = scanpos;
                    matchlen = len;
                    if (maxmatch <= len) break;
                }
            }
            scanpos = this.prev[scanpos & this.DictionarySize - 1];
        }
        this.put(position);
        if (matchpos < position) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    private boolean isTooBig(int hash) {
        return (this.tooBigFlag[hash >> 4] & 1 << (hash & 0xF)) != 0;
    }

    private void setTooBigFlag(int hash) {
        int n = hash >> 4;
        this.tooBigFlag[n] = (char)(this.tooBigFlag[n] | 1 << (hash & 0xF));
    }

    private void clearTooBigFlag(int hash) {
        int n = hash >> 4;
        this.tooBigFlag[n] = (char)(this.tooBigFlag[n] & ~(1 << (hash & 0xF)));
    }
}

