/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.candle.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import jp.sf.orangesignal.ta.FourPrice;
import jp.sf.orangesignal.ta.candle.Candlestick;
import jp.sf.orangesignal.ta.candle.generator.CandlestickGenerateException;
import jp.sf.orangesignal.ta.candle.generator.CandlestickGenerator;
import jp.sf.orangesignal.ta.candle.generator.CandlestickGeneratorSettings;
import jp.sf.orangesignal.ta.candle.generator.TrendProcessor;
import jp.sf.orangesignal.ta.data.DatasetSource;
import jp.sf.orangesignal.ta.data.annotation.AnnotationParser;

public class AnnotationCandlestickGenerator
extends CandlestickGenerator {
    public static final String DEFAULT_DATE_NAME = "date";
    public static final Map<FourPrice, String> DEFAULT_PRICE_NAME_MAP;

    public AnnotationCandlestickGenerator() {
    }

    public AnnotationCandlestickGenerator(CandlestickGeneratorSettings settings) {
        super(settings);
    }

    public Candlestick[] generate(Object dataset) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(dataset, DEFAULT_DATE_NAME, DEFAULT_PRICE_NAME_MAP, null, this.settings);
    }

    public Candlestick[] generate(Object dataset, TrendProcessor processor) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(dataset, DEFAULT_DATE_NAME, DEFAULT_PRICE_NAME_MAP, processor, this.settings);
    }

    public static Candlestick[] generate(Object dataset, TrendProcessor processor, CandlestickGeneratorSettings settings) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(dataset, DEFAULT_DATE_NAME, DEFAULT_PRICE_NAME_MAP, processor, settings);
    }

    public Candlestick[] generate(Object dataset, String date, Map<FourPrice, String> price) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(dataset, date, price, null, this.settings);
    }

    public Candlestick[] generate(Object dataset, String date, Map<FourPrice, String> price, TrendProcessor processor) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(dataset, date, price, processor, this.settings);
    }

    public static Candlestick[] generate(Object dataset, String date, Map<FourPrice, String> price, TrendProcessor processor, CandlestickGeneratorSettings settings) throws CandlestickGenerateException {
        DatasetSource items = AnnotationParser.parse(dataset);
        return AnnotationCandlestickGenerator.generate(items.getDate(date), items.getNumber(price.get((Object)FourPrice.OPEN)), items.getNumber(price.get((Object)FourPrice.HIGH)), items.getNumber(price.get((Object)FourPrice.LOW)), items.getNumber(price.get((Object)FourPrice.CLOSE)), processor, settings);
    }

    public Candlestick[] generate(Collection<?> c) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(c, DEFAULT_DATE_NAME, DEFAULT_PRICE_NAME_MAP, null, this.settings);
    }

    public Candlestick[] generate(Collection<?> c, TrendProcessor processor) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(c, DEFAULT_DATE_NAME, DEFAULT_PRICE_NAME_MAP, processor, this.settings);
    }

    public static Candlestick[] generate(Collection<?> c, TrendProcessor processor, CandlestickGeneratorSettings settings) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(c, DEFAULT_DATE_NAME, DEFAULT_PRICE_NAME_MAP, processor, settings);
    }

    public Candlestick[] generate(Collection<?> c, String date, Map<FourPrice, String> price) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(c, date, price, null, this.settings);
    }

    public Candlestick[] generate(Collection<?> c, String date, Map<FourPrice, String> price, TrendProcessor processor) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(c, date, price, processor, this.settings);
    }

    public static Candlestick[] generate(Collection<?> c, String date, Map<FourPrice, String> price, TrendProcessor processor, CandlestickGeneratorSettings settings) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(c.toArray(), date, price, processor, settings);
    }

    public Candlestick[] generate(Object[] array) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(array, DEFAULT_DATE_NAME, DEFAULT_PRICE_NAME_MAP, null, this.settings);
    }

    public Candlestick[] generate(Object[] array, TrendProcessor processor) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(array, DEFAULT_DATE_NAME, DEFAULT_PRICE_NAME_MAP, processor, this.settings);
    }

    public static Candlestick[] generate(Object[] array, TrendProcessor processor, CandlestickGeneratorSettings settings) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(array, DEFAULT_DATE_NAME, DEFAULT_PRICE_NAME_MAP, processor, settings);
    }

    public Candlestick[] generate(Object[] array, String date, Map<FourPrice, String> price) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(array, date, price, null, this.settings);
    }

    public Candlestick[] generate(Object[] array, String date, Map<FourPrice, String> price, TrendProcessor processor) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(array, date, price, processor, this.settings);
    }

    public static Candlestick[] generate(Object[] array, String date, Map<FourPrice, String> price, TrendProcessor processor, CandlestickGeneratorSettings settings) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(array, date, price.get((Object)FourPrice.OPEN), price.get((Object)FourPrice.HIGH), price.get((Object)FourPrice.LOW), price.get((Object)FourPrice.CLOSE), processor, settings);
    }

    public static Candlestick[] generate(Object[] array, String date, String open, String high, String low, String close, TrendProcessor processor, CandlestickGeneratorSettings settings) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(AnnotationParser.parse(array), date, open, high, low, close, processor, settings);
    }

    private static Candlestick[] generate(DatasetSource items, String date, String open, String high, String low, String close, TrendProcessor processor, CandlestickGeneratorSettings settings) throws CandlestickGenerateException {
        return AnnotationCandlestickGenerator.generate(date == null ? null : items.getDate(date), items.getNumber(open), items.getNumber(high), items.getNumber(low), items.getNumber(close), processor, settings);
    }

    static {
        EnumMap<FourPrice, String> map = new EnumMap<FourPrice, String>(FourPrice.class);
        map.put(FourPrice.OPEN, "open");
        map.put(FourPrice.HIGH, "high");
        map.put(FourPrice.LOW, "low");
        map.put(FourPrice.CLOSE, "close");
        DEFAULT_PRICE_NAME_MAP = Collections.unmodifiableMap(map);
    }
}

