/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.data.model;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.util.Date;
import jp.sf.orangesignal.ta.data.CompressType;
import jp.sf.orangesignal.ta.data.annotation.DateItem;
import jp.sf.orangesignal.ta.data.annotation.NumberCompressorType;
import jp.sf.orangesignal.ta.data.annotation.NumberItem;

@NumberCompressorType(value=CompressType.SUM)
public class StockSplit
implements Serializable,
Comparable<StockSplit> {
    private static final long serialVersionUID = 3270022426162558867L;
    @DateItem
    protected Date date;
    @NumberItem
    @NumberCompressorType(value=CompressType.SUM)
    protected Number split;

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Number getSplit() {
        return this.split;
    }

    public void setSplit(Number split) {
        this.split = split;
    }

    @Override
    public int compareTo(StockSplit o) {
        return this.date.compareTo(o.date);
    }

    public String toString() {
        Field[] fields;
        StringBuilder sb = new StringBuilder();
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(field.getName()).append('=');
            try {
                Object value = field.get(this);
                if (value == null) {
                    sb.append("null");
                    continue;
                }
                if (value instanceof Date) {
                    sb.append(DateFormat.getDateTimeInstance().format((Date)value));
                    continue;
                }
                sb.append(value.toString());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return this.getClass().getSimpleName() + ' ' + sb;
    }
}

