/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jp.sf.orangesignal.ta.candle.Candlestick;
import jp.sf.orangesignal.ta.util.Assert;
import jp.sf.orangesignal.trading.DefaultPosition;
import jp.sf.orangesignal.trading.MarketPositionType;
import jp.sf.orangesignal.trading.Position;
import jp.sf.orangesignal.trading.PositionType;
import jp.sf.orangesignal.trading.TradeType;
import jp.sf.orangesignal.trading.Trader;
import jp.sf.orangesignal.trading.VirtualAccount;
import jp.sf.orangesignal.trading.commission.Commission;
import jp.sf.orangesignal.trading.commission.FreeCommission;
import jp.sf.orangesignal.trading.data.Dataset;
import jp.sf.orangesignal.trading.order.LimitOrder;
import jp.sf.orangesignal.trading.order.MarketOrder;
import jp.sf.orangesignal.trading.order.Order;
import jp.sf.orangesignal.trading.order.StopOrder;

public class VirtualTrader
implements Trader {
    private Commission commission;
    private double slippage;
    private VirtualAccount account;
    private double initialCapital;
    private int positionLimit = 0;
    private int defaultQuantity = 1;
    private TradeType tradeType = TradeType.LONG_AND_SHORT_AND_REVERSE;
    private Map<String, Dataset> datasetMap = new HashMap<String, Dataset>();
    private LinkedList<Position> currentPositions = new LinkedList();
    private LinkedList<Position> positions = new LinkedList();
    private int seq = 1;

    public VirtualTrader() {
    }

    public VirtualTrader(Dataset dataset, double initCash) {
        this(dataset, new VirtualAccount(initCash));
    }

    public VirtualTrader(Dataset dataset, VirtualAccount account) {
        this(dataset, account, new FreeCommission());
    }

    public VirtualTrader(Dataset dataset, VirtualAccount account, Commission commission) {
        Assert.notNull((Object)account, (String)"Account must not be null");
        Assert.notNull((Object)commission, (String)"Commission must not be null");
        this.setDataset(null, dataset);
        this.setAccount(account);
        this.commission = commission;
    }

    public void reset() {
        if (this.account != null) {
            this.account.setCash(this.initialCapital);
        }
        this.currentPositions = new LinkedList();
        this.positions = new LinkedList();
        this.seq = 1;
    }

    @Override
    public Commission getCommission() {
        return this.commission;
    }

    public void setCommission(Commission commission) {
        this.commission = commission;
    }

    public double getSlippage() {
        return this.slippage;
    }

    public void setSlippage(double slippage) {
        this.slippage = slippage;
    }

    @Override
    public VirtualAccount getAccount() {
        return this.account;
    }

    public void setAccount(VirtualAccount account) {
        this.initialCapital = account.getCash();
        this.account = account;
    }

    public double getInitialCapital() {
        return this.initialCapital;
    }

    public int getPositionLimit() {
        return this.positionLimit;
    }

    public void setPositionLimit(int positionLimit) {
        this.positionLimit = positionLimit;
    }

    @Override
    public int getDefaultQuantity() {
        return this.defaultQuantity;
    }

    @Override
    public void setDefaultQuantity(int defaultQuantity) {
        this.defaultQuantity = defaultQuantity;
    }

    public TradeType getTradeType() {
        return this.tradeType;
    }

    public void setTradeType(TradeType tradeType) {
        this.tradeType = tradeType;
    }

    public void setDatasetMap(Map<String, Dataset> datasetMap) {
        this.datasetMap = datasetMap;
        this.reset();
    }

    private Dataset getDataset(String symbol) {
        return this.datasetMap.get(symbol);
    }

    public void setDataset(String symbol, Dataset dataset) {
        Assert.notNull((Object)((Object)dataset), (String)"Dataset must not be null");
        this.datasetMap = new HashMap<String, Dataset>(2);
        this.datasetMap.put(symbol == null ? "" : symbol, dataset);
    }

    @Override
    public MarketPositionType getMarketPositionType(String symbol) {
        LinkedList<Position> positions = this.getPositionListBySymbol(this.currentPositions, symbol);
        boolean l = false;
        boolean s = false;
        for (Position p : positions) {
            l = l || p.getType() == PositionType.LONG;
            s = s || p.getType() == PositionType.SHORT;
        }
        return MarketPositionType.valueOf(l, s);
    }

    @Override
    public Position getCurrentPosition(String symbol) {
        LinkedList<Position> positions = this.getPositionListBySymbol(this.currentPositions, symbol);
        return positions.isEmpty() ? null : positions.getLast();
    }

    @Override
    public LinkedList<Position> getCurrentPositions(String symbol) {
        return this.getPositionListBySymbol(this.currentPositions, symbol);
    }

    @Override
    public LinkedList<Position> getPositions() {
        return this.positions;
    }

    @Override
    public LinkedList<Position> getPositionsBySymbol(String symbol) {
        return this.getPositionListBySymbol(this.positions, symbol);
    }

    @Override
    public LinkedList<Position> getPositionsByEntryLabel(String label) {
        return this.getPositionListByEntryLabel(this.positions, label);
    }

    @Override
    public LinkedList<Position> getPositionsByExitLabel(String label) {
        return this.getPositionListByExitLabel(this.positions, label);
    }

    @Override
    public LinkedList<Position> getPositionsByLabel(String label) {
        return this.getPositionListByLabel(this.positions, label);
    }

    private LinkedList<Position> getPositionListBySymbol(Collection<Position> positions, String symbol) {
        LinkedList<Position> results = new LinkedList<Position>();
        String s = symbol == null ? "" : symbol;
        for (Position p : positions) {
            if (!s.equals(p.getSymbol())) continue;
            results.add(p);
        }
        return results;
    }

    private LinkedList<Position> getPositionListByEntryLabel(Collection<Position> positions, String label) {
        LinkedList<Position> results = new LinkedList<Position>();
        String s = label == null ? "" : label;
        for (Position p : positions) {
            if (!s.equals(p.getEntryLabel())) continue;
            results.add(p);
        }
        return results;
    }

    private LinkedList<Position> getPositionListByExitLabel(Collection<Position> positions, String label) {
        LinkedList<Position> results = new LinkedList<Position>();
        String s = label == null ? "" : label;
        for (Position p : positions) {
            if (!s.equals(p.getExitLabel())) continue;
            results.add(p);
        }
        return results;
    }

    private LinkedList<Position> getPositionListByLabel(Collection<Position> positions, String label) {
        LinkedList<Position> results = new LinkedList<Position>();
        String s = label == null ? "" : label;
        for (Position p : positions) {
            if (!s.equals(p.getEntryLabel()) && !s.equals(p.getExitLabel())) continue;
            results.add(p);
        }
        return results;
    }

    @Override
    public void buy(Order order) {
        InternalOrder o = this.contract(order, PositionType.LONG);
        if (o != null) {
            this.buy(o);
        }
    }

    @Override
    public void sellShort(Order order) {
        InternalOrder o = this.contract(order, PositionType.SHORT);
        if (o != null) {
            this.sell(o);
        }
    }

    @Override
    public void sell(Order order) {
        InternalOrder o = this.contract(order, PositionType.SHORT);
        if (o != null) {
            this.exitLong(o, order.getFindId(), order.getFindLabel());
        }
    }

    @Override
    public void buyToCover(Order order) {
        InternalOrder o = this.contract(order, PositionType.LONG);
        if (o != null) {
            this.exitShort(o, order.getFindId(), order.getFindLabel());
        }
    }

    private Candlestick getTargetCandlestick(Order order) {
        Dataset dataset = this.getDataset(order.getSymbol());
        if (dataset == null) {
            return null;
        }
        int i = dataset.indexOf(order.getDate());
        if (i == -1) {
            return null;
        }
        Candlestick[] c = dataset.getCandlestick();
        if (c.length <= (i += order.getPeriod())) {
            return null;
        }
        return c[i];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InternalOrder contract(Order order, PositionType type) {
        Candlestick c = this.getTargetCandlestick(order);
        if (c == null) {
            return null;
        }
        InternalOrder result = new InternalOrder();
        result.symbol = order.getSymbol();
        result.label = order.getLabel();
        result.date = c.getDate();
        result.quantity = order.getQuantity();
        result.slippage = this.slippage;
        if (order instanceof MarketOrder) {
            MarketOrder o = (MarketOrder)order;
            switch (o.getPriceType()) {
                case OPEN: {
                    result.price = c.getOpen();
                    return result;
                }
                case HIGH: {
                    result.price = c.getHigh();
                    return result;
                }
                case LOW: {
                    result.price = c.getLow();
                    return result;
                }
                case CLOSE: {
                    result.price = c.getClose();
                    return result;
                }
                default: {
                    return null;
                }
            }
        } else if (order instanceof LimitOrder) {
            LimitOrder o = (LimitOrder)order;
            double limit = o.getLimitPrice();
            if (c.contains(limit)) {
                result.price = limit;
                return result;
            } else if (type == PositionType.LONG && c.getHigh() < limit) {
                result.price = c.getHigh();
                return result;
            } else {
                if (type != PositionType.SHORT || !(c.getLow() > limit)) return null;
                result.price = c.getLow();
            }
            return result;
        } else {
            if (!(order instanceof StopOrder)) return null;
            StopOrder o = (StopOrder)order;
            double stop = o.getStopPrice();
            if (c.contains(o.getStopPrice())) {
                result.price = o.getStopPrice();
                return result;
            } else if (type == PositionType.SHORT && c.getHigh() < stop) {
                result.price = c.getHigh();
                return result;
            } else {
                if (type != PositionType.LONG || !(c.getLow() > stop)) return null;
                result.price = c.getLow();
            }
        }
        return result;
    }

    private void buy(InternalOrder o) {
        boolean reverse;
        MarketPositionType mp = this.getMarketPositionType(o.symbol);
        boolean bl = reverse = mp.isShort() && this.tradeType.isReverse();
        if (mp.isShort()) {
            this.exitPosition(o, true, null, null);
        }
        if ((this.tradeType.isLong() && !mp.isShort() || reverse) && (!mp.isLong() || this.positionLimit > 0 && this.positionLimit + 1 > this.currentPositions.size())) {
            int qty = o.quantity > 0 ? o.quantity : this.defaultQuantity;
            double commission = this.commission.calcCommission(o.price, qty);
            if (this.account.withdraw(o.price * (double)qty)) {
                this.currentPositions.add(new DefaultPosition(this.seq++, o.symbol, PositionType.LONG, o.label, o.date, o.price, qty, commission, this.slippage));
            }
        }
    }

    private void sell(InternalOrder o) {
        boolean reverse;
        MarketPositionType mp = this.getMarketPositionType(o.symbol);
        boolean bl = reverse = mp.isLong() && this.tradeType.isReverse();
        if (mp.isLong()) {
            this.exitPosition(o, true, null, null);
        }
        if ((this.tradeType.isShort() && !mp.isLong() || reverse) && (!mp.isShort() || this.positionLimit > 0 && this.positionLimit + 1 > this.currentPositions.size())) {
            int qty = o.quantity > 0 ? o.quantity : this.defaultQuantity;
            double commission = this.commission.calcCommission(o.price, qty);
            if (this.account.withdraw(o.price * (double)qty)) {
                this.currentPositions.add(new DefaultPosition(this.seq++, o.symbol, PositionType.SHORT, o.label, o.date, o.price, qty, commission, this.slippage));
            }
        }
    }

    private void exitLong(InternalOrder o, Integer findId, String findLabel) {
        if (this.getMarketPositionType(o.symbol).isLong()) {
            this.exitPosition(o, false, findId, findLabel);
        }
    }

    private void exitShort(InternalOrder o, Integer findId, String findLabel) {
        if (this.getMarketPositionType(o.symbol).isShort()) {
            this.exitPosition(o, false, findId, findLabel);
        }
    }

    private void exitPosition(InternalOrder o, boolean all, Integer findId, String findLabel) {
        int count = o.quantity;
        int i = 0;
        while (i < this.currentPositions.size() && (o.quantity <= 0 || count > 0)) {
            Position p = this.currentPositions.get(i);
            boolean match = false;
            if (o.symbol.equals(p.getSymbol())) {
                if (all) {
                    match = true;
                } else if (findId != null) {
                    if (findId.intValue() == p.getId()) {
                        match = true;
                    }
                } else if (findLabel == null || findLabel.isEmpty() || findLabel.equals(p.getEntryLabel())) {
                    match = true;
                }
            }
            if (match) {
                int qty;
                int entry = p.getEntryQuantity();
                if (o.quantity > 0 && !all) {
                    qty = Math.min(count, entry);
                    count -= qty;
                } else {
                    qty = entry;
                }
                double commission = this.commission.calcCommission(o.price, qty);
                int period = this.getDataset(o.symbol).getPeriod(p.getEntryDate(), o.date) - 1;
                Position split = p.close(this.seq++, o.label, o.date, o.price, qty, commission, this.slippage, period);
                this.currentPositions.remove(i);
                this.positions.add(p);
                this.account.deposit(o.price * (double)qty);
                if (split == null) continue;
                this.currentPositions.add(i, split);
                ++i;
                continue;
            }
            ++i;
        }
    }

    private class InternalOrder {
        protected String symbol;
        protected String label;
        protected Date date;
        protected double price;
        protected int quantity;
        protected double slippage;

        private InternalOrder() {
        }
    }
}

