/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading.commission;

import jp.sf.orangesignal.ta.PercentageScale;
import jp.sf.orangesignal.trading.commission.CommissionUnit;

public class RateCommission
extends CommissionUnit {
    private static final long serialVersionUID = -904663648825498390L;
    private double rate;
    private PercentageScale scale;
    private double adding;
    private double min;
    private double max;

    public RateCommission() {
        this(0.0, PercentageScale.PERCENT, 0.0, 0.0, 0.0);
    }

    public RateCommission(double rate, PercentageScale scale) {
        this(rate, scale, 0.0, 0.0, 0.0);
    }

    public RateCommission(double rate, PercentageScale scale, double adding) {
        this(rate, scale, adding, 0.0, 0.0);
    }

    public RateCommission(double rate, PercentageScale scale, double min, double max) {
        this(rate, scale, 0.0, min, max);
    }

    public RateCommission(double rate, PercentageScale scale, double adding, double min, double max) {
        this.rate = rate;
        this.scale = scale;
        this.adding = adding;
        this.min = min;
        this.max = max;
    }

    public RateCommission(double base, double rate, PercentageScale scale) {
        this(base, rate, scale, 0.0, 0.0, 0.0);
    }

    public RateCommission(double base, double rate, PercentageScale scale, double adding) {
        this(base, rate, scale, adding, 0.0, 0.0);
    }

    public RateCommission(double base, double rate, PercentageScale scale, double min, double max) {
        this(base, rate, scale, 0.0, min, max);
    }

    public RateCommission(double base, double rate, PercentageScale scale, double adding, double min, double max) {
        super(base);
        this.rate = rate;
        this.scale = scale;
        this.adding = adding;
        this.min = min;
        this.max = max;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public PercentageScale getScale() {
        return this.scale;
    }

    public void setScale(PercentageScale scale) {
        this.scale = scale;
    }

    public double getAdding() {
        return this.adding;
    }

    public void setAdding(double adding) {
        this.adding = adding;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    @Override
    public double calcCommission(double price, int quantity) {
        double result = price * (double)quantity / this.scale.scale() * this.rate + this.adding;
        if (this.min != 0.0 && result < this.min) {
            result = this.min;
        }
        if (this.max != 0.0 && result > this.max) {
            result = this.max;
        }
        return result;
    }
}

