/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading.data;

import java.util.Date;
import jp.sf.orangesignal.ta.FourPrice;
import jp.sf.orangesignal.ta.data.CompressType;
import jp.sf.orangesignal.ta.data.annotation.AnnotationParser;
import jp.sf.orangesignal.ta.data.annotation.NumberCompressorType;
import jp.sf.orangesignal.ta.data.model.Price;
import jp.sf.orangesignal.ta.data.model.PriceDataset;
import jp.sf.orangesignal.ta.data.model.TechnicalPriceDataset;
import jp.sf.orangesignal.ta.util.ArrayUtils;
import jp.sf.orangesignal.ta.util.Assert;
import jp.sf.orangesignal.ta.util.DateArrayUtils;
import jp.sf.orangesignal.trading.data.IntervalType;

@NumberCompressorType(value=CompressType.SUM)
public class Dataset
extends TechnicalPriceDataset {
    private static final long serialVersionUID = 1689616808276855902L;
    private IntervalType interval;
    private String symbol;
    private String symbolName;

    public Dataset() {
    }

    public Dataset(PriceDataset dataset, IntervalType interval, String symbol, String symbolName) {
        super(dataset);
        this.interval = interval;
        this.symbol = symbol;
        this.symbolName = symbolName;
    }

    public static Dataset newInstance(Price[] prices, IntervalType interval, String symbol, String symbolName) {
        Assert.notEmpty((Object[])prices, (String)"Prices must not be empty");
        return new Dataset((PriceDataset)AnnotationParser.parse((Object[])prices).build(PriceDataset.class).execute(), interval, symbol, symbolName);
    }

    public int getLength() {
        return this.date == null ? 0 : this.date.length;
    }

    public int indexOf(Date find) {
        return DateArrayUtils.indexOf((Date[])this.date, (Date)find);
    }

    public int lastIndexOf(Date find) {
        return DateArrayUtils.lastIndexOf((Date[])this.date, (Date)find);
    }

    public int defaultIndexOf(Date find) {
        int result = -1;
        if (find != null) {
            result = DateArrayUtils.indexOf((Date[])this.date, (Date)find);
        }
        if (result != -1) {
            return result;
        }
        return ArrayUtils.notNullIndexOf((Object[])this.date);
    }

    public int defaultLastIndexOf(Date find) {
        int result = -1;
        if (find != null) {
            result = DateArrayUtils.lastIndexOf((Date[])this.date, (Date)find);
        }
        if (result != -1) {
            return result;
        }
        return ArrayUtils.notNullLastIndexOf((Object[])this.date);
    }

    public int getPeriod(Date start, Date end) {
        int startIndex = this.indexOf(start);
        int endIndex = this.lastIndexOf(end);
        if (startIndex != -1 && endIndex != -1) {
            return endIndex - startIndex + 1;
        }
        return 0;
    }

    public Number[] getPrice(FourPrice type) {
        switch (type) {
            case OPEN: {
                return this.getOpen();
            }
            case HIGH: {
                return this.getHigh();
            }
            case LOW: {
                return this.getLow();
            }
            case CLOSE: {
                return this.getClose();
            }
        }
        return null;
    }

    public Number[] getTechnicalPrice(FourPrice type) {
        switch (type) {
            case OPEN: {
                return this.getTechnicalOpen();
            }
            case HIGH: {
                return this.getTechnicalHigh();
            }
            case LOW: {
                return this.getTechnicalLow();
            }
            case CLOSE: {
                return this.getTechnicalClose();
            }
        }
        return null;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public void setSymbolName(String symbolName) {
        this.symbolName = symbolName;
    }

    public IntervalType getInterval() {
        return this.interval;
    }

    public void setInterval(IntervalType interval) {
        this.interval = interval;
    }
}

