/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading.data;

import java.io.IOException;
import java.util.Map;
import jp.sf.orangesignal.ta.data.CsvPriceLoader;
import jp.sf.orangesignal.ta.data.model.Price;
import jp.sf.orangesignal.trading.data.Dataset;
import jp.sf.orangesignal.trading.data.DatasetLoader;
import jp.sf.orangesignal.trading.data.IntervalType;
import jp.sf.orangesignal.trading.data.LoadException;

public class FileDatasetLoader
implements DatasetLoader {
    private CsvPriceLoader loader = new CsvPriceLoader();
    private Map<String, String> symbols;
    private IntervalType interval = IntervalType.DAILY;

    public void setLoader(CsvPriceLoader loader) {
        this.loader = loader;
    }

    public void setSymbols(Map<String, String> symbolMap) {
        this.symbols = symbolMap;
    }

    public void setInterval(IntervalType interval) {
        this.interval = interval;
    }

    @Override
    public Dataset load(String symbol) throws LoadException {
        try {
            return Dataset.newInstance(this.loader.load(symbol).toArray(new Price[0]), this.interval, symbol, this.symbols != null ? this.symbols.get(symbol) : null);
        }
        catch (IOException e) {
            throw new LoadException(e.getMessage(), e);
        }
    }
}

