/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.order;

/**
 * 注文方法の種類を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum OrderTiming {

	/**
	 * 当日の終値で成行注文する事を表します。
	 */
	CURRENT_CLOSE { @Override public OrderType getOrderType() { return OrderType.MARKET; } },

	/**
	 * 翌日の始値で成行注文する事を表します。
	 */
	NEXT_OPEN { @Override public OrderType getOrderType() { return OrderType.MARKET; } },

	/**
	 * 翌日の終値で成行注文する事を表します。
	 */
	NEXT_CLOSE { @Override public OrderType getOrderType() { return OrderType.MARKET; } },

	/**
	 * 翌日に指値注文する事を表します。
	 */
	NEXT_LIMIT { @Override public OrderType getOrderType() { return OrderType.LIMIT; } },

	/**
	 * 翌日に逆指値注文する事を表します。
	 */
	NEXT_STOP { @Override public OrderType getOrderType() { return OrderType.STOP; } };

	/**
	 * この列挙型に対応する注文の種類を返します。
	 * 
	 * @return 注文の種類
	 */
	public abstract OrderType getOrderType();

}
