/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc;

import java.util.List;
import org.seasar.extension.jdbc.JoinColumnMeta;
import org.seasar.extension.jdbc.JoinType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromClause {
    protected StringBuilder sql;

    public FromClause() {
        this(100);
    }

    public FromClause(int capacity) {
        this.sql = new StringBuilder(capacity);
    }

    public int getLength() {
        return this.sql.length();
    }

    public String toSql() {
        return this.sql.toString();
    }

    public void addSql(String tableName, String tableAlias) {
        this.sql.append(" from ");
        this.sql.append(tableName);
        this.sql.append(" ");
        this.sql.append(tableAlias);
    }

    public void addSql(String tableName, String tableAlias, String lockHint) {
        this.sql.append(" from ").append(tableName).append(" ").append(tableAlias).append(lockHint);
    }

    public void addSql(JoinType joinType, String tableName, String tableAlias, String fkTableAlias, String pkTableAlias, List<JoinColumnMeta> joinColumnMetaList, String lockHint) {
        switch (joinType) {
            case INNER: {
                this.sql.append(" inner join ");
                break;
            }
            case LEFT_OUTER: {
                this.sql.append(" left outer join ");
            }
        }
        this.sql.append(tableName).append(" ").append(tableAlias).append(lockHint).append(" on");
        for (int i = 0; i < joinColumnMetaList.size(); ++i) {
            if (i == 0) {
                this.sql.append(" ");
            } else {
                this.sql.append(" and ");
            }
            JoinColumnMeta jcm = joinColumnMetaList.get(i);
            this.sql.append(fkTableAlias).append(".").append(jcm.getName()).append(" = ");
            this.sql.append(pkTableAlias).append(".").append(jcm.getReferencedColumnName());
        }
    }
}

