/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util.tiger;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericUtil {
    private GenericUtil() {
    }

    public static boolean isTypeOf(Type type, Class<?> clazz) {
        if (Class.class.isInstance(type)) {
            return clazz.isAssignableFrom((Class)Class.class.cast(type));
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return GenericUtil.isTypeOf(parameterizedType.getRawType(), clazz);
        }
        return false;
    }

    public static Class<?> getRawClass(Type type) {
        if (Class.class.isInstance(type)) {
            return (Class)Class.class.cast(type);
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return GenericUtil.getRawClass(parameterizedType.getRawType());
        }
        if (GenericArrayType.class.isInstance(type)) {
            GenericArrayType genericArrayType = (GenericArrayType)GenericArrayType.class.cast(type);
            Class<?> rawClass = GenericUtil.getRawClass(genericArrayType.getGenericComponentType());
            return Array.newInstance(rawClass, 0).getClass();
        }
        return null;
    }

    public static Type[] getGenericParameter(Type type) {
        if (ParameterizedType.class.isInstance(type)) {
            return ((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments();
        }
        if (GenericArrayType.class.isInstance(type)) {
            return GenericUtil.getGenericParameter(((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType());
        }
        return null;
    }

    public static Type getGenericParameter(Type type, int index) {
        if (!ParameterizedType.class.isInstance(type)) {
            return null;
        }
        Type[] genericParameter = GenericUtil.getGenericParameter(type);
        if (genericParameter == null) {
            return null;
        }
        return genericParameter[index];
    }

    public static Type getElementTypeOfArray(Type type) {
        if (!GenericArrayType.class.isInstance(type)) {
            return null;
        }
        return ((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType();
    }

    public static Type getElementTypeOfCollection(Type type) {
        if (!GenericUtil.isTypeOf(type, Collection.class)) {
            return null;
        }
        return GenericUtil.getGenericParameter(type, 0);
    }

    public static Type getElementTypeOfList(Type type) {
        if (!GenericUtil.isTypeOf(type, List.class)) {
            return null;
        }
        return GenericUtil.getGenericParameter(type, 0);
    }

    public static Type getElementTypeOfSet(Type type) {
        if (!GenericUtil.isTypeOf(type, Set.class)) {
            return null;
        }
        return GenericUtil.getGenericParameter(type, 0);
    }

    public static Type getKeyTypeOfMap(Type type) {
        if (!GenericUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return GenericUtil.getGenericParameter(type, 0);
    }

    public static Type getValueTypeOfMap(Type type) {
        if (!GenericUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return GenericUtil.getGenericParameter(type, 1);
    }

    public static Map<TypeVariable<?>, Type> getTypeVariableMap(Class<?> clazz) {
        LinkedHashMap<TypeVariable<?>, Type> map = CollectionsUtil.newLinkedHashMap();
        Class<?> superClass = clazz.getSuperclass();
        Type superClassType = clazz.getGenericSuperclass();
        if (superClass != null) {
            GenericUtil.gatherTypeVariables(superClass, superClassType, map);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        Type[] interfaceTypes = clazz.getGenericInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            GenericUtil.gatherTypeVariables(interfaces[i], interfaceTypes[i], map);
        }
        return map;
    }

    protected static void gatherTypeVariables(Class<?> clazz, Type type, Map<TypeVariable<?>, Type> map) {
        if (clazz == null) {
            return;
        }
        GenericUtil.gatherTypeVariables(type, map);
        Class<?> superClass = clazz.getSuperclass();
        Type superClassType = clazz.getGenericSuperclass();
        if (superClass != null) {
            GenericUtil.gatherTypeVariables(superClass, superClassType, map);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        Type[] interfaceTypes = clazz.getGenericInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            GenericUtil.gatherTypeVariables(interfaces[i], interfaceTypes[i], map);
        }
    }

    protected static void gatherTypeVariables(Type type, Map<TypeVariable<?>, Type> map) {
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            TypeVariable<?>[] typeVariables = ((GenericDeclaration)GenericDeclaration.class.cast(parameterizedType.getRawType())).getTypeParameters();
            Type[] actualTypes = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < actualTypes.length; ++i) {
                map.put(typeVariables[i], actualTypes[i]);
            }
        }
    }

    public static Class<?> getActualClass(Type type, Map<TypeVariable<?>, Type> map) {
        if (Class.class.isInstance(type)) {
            return (Class)Class.class.cast(type);
        }
        if (ParameterizedType.class.isInstance(type)) {
            return GenericUtil.getActualClass(((ParameterizedType)ParameterizedType.class.cast(type)).getRawType(), map);
        }
        if (TypeVariable.class.isInstance(type)) {
            return GenericUtil.getActualClass(map.get(TypeVariable.class.cast(type)), map);
        }
        if (GenericArrayType.class.isInstance(type)) {
            GenericArrayType genericArrayType = (GenericArrayType)GenericArrayType.class.cast(type);
            Class<?> componentClass = GenericUtil.getActualClass(genericArrayType.getGenericComponentType(), map);
            return Array.newInstance(componentClass, 0).getClass();
        }
        return null;
    }

    public static Class<?> getActualElementClassOfArray(Type type, Map<TypeVariable<?>, Type> map) {
        if (!GenericArrayType.class.isInstance(type)) {
            return null;
        }
        return GenericUtil.getActualClass(((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType(), map);
    }

    public static Class<?> getActualElementClassOfCollection(Type type, Map<TypeVariable<?>, Type> map) {
        if (!GenericUtil.isTypeOf(type, Collection.class)) {
            return null;
        }
        return GenericUtil.getActualClass(GenericUtil.getGenericParameter(type, 0), map);
    }

    public static Class<?> getActualElementClassOfList(Type type, Map<TypeVariable<?>, Type> map) {
        if (!GenericUtil.isTypeOf(type, List.class)) {
            return null;
        }
        return GenericUtil.getActualClass(GenericUtil.getGenericParameter(type, 0), map);
    }

    public static Class<?> getActualElementClassOfSet(Type type, Map<TypeVariable<?>, Type> map) {
        if (!GenericUtil.isTypeOf(type, Set.class)) {
            return null;
        }
        return GenericUtil.getActualClass(GenericUtil.getGenericParameter(type, 0), map);
    }

    public static Class<?> getActualKeyClassOfMap(Type type, Map<TypeVariable<?>, Type> map) {
        if (!GenericUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return GenericUtil.getActualClass(GenericUtil.getGenericParameter(type, 0), map);
    }

    public static Class<?> getActualValueClassOfMap(Type type, Map<TypeVariable<?>, Type> map) {
        if (!GenericUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return GenericUtil.getActualClass(GenericUtil.getGenericParameter(type, 1), map);
    }
}

