/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.data;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipFile;
import jp.gr.java_conf.dangan.util.lha.LhaFile;
import jp.sf.orangesignal.csv.Csv;
import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.CsvListHandler;
import jp.sf.orangesignal.ta.data.CsvDataConfig;
import jp.sf.orangesignal.ta.util.Assert;

public abstract class CsvDataLoader<T> {
    private CsvDataConfig config;
    private CsvListHandler<T> handler;

    public void setConfig(CsvDataConfig config) {
        this.config = config;
    }

    public void setHandler(CsvListHandler<T> handler) {
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> load(String symbol) throws IOException {
        List list;
        File file = this.getFile(symbol);
        switch (this.config.getType()) {
            case ZIP: {
                ZipFile zipFile = new ZipFile(file);
                try {
                    list = Csv.load((ZipFile)zipFile, (String)this.config.getEncoding(), (CsvConfig)this.config.getCsvConfig(), this.handler);
                    break;
                }
                finally {
                    zipFile.close();
                }
            }
            case LHA: {
                LhaFile lhaFile = new LhaFile(file);
                try {
                    list = Csv.load((LhaFile)lhaFile, (String)this.config.getEncoding(), (CsvConfig)this.config.getCsvConfig(), this.handler);
                    break;
                }
                finally {
                    lhaFile.close();
                }
            }
            default: {
                list = (List)Csv.load((File)file, (String)this.config.getEncoding(), (CsvConfig)this.config.getCsvConfig(), this.handler);
            }
        }
        if (this.config.isReverseOrder()) {
            Collections.sort(list, Collections.reverseOrder());
        }
        return list;
    }

    private File getFile(String symbol) {
        Assert.notEmpty(symbol, "Symbol must not be empty");
        return new File(this.config.getPath(), symbol + '.' + this.config.getType().toString().toLowerCase());
    }
}

