/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.data.model;

import jp.sf.orangesignal.ta.candle.Candlestick;
import jp.sf.orangesignal.ta.candle.generator.CandlestickGenerator;
import jp.sf.orangesignal.ta.data.CompressType;
import jp.sf.orangesignal.ta.data.DataConvertUtils;
import jp.sf.orangesignal.ta.data.annotation.AnnotationParser;
import jp.sf.orangesignal.ta.data.annotation.NumberCompressorType;
import jp.sf.orangesignal.ta.data.annotation.NumberItem;
import jp.sf.orangesignal.ta.data.model.Price;
import jp.sf.orangesignal.ta.data.model.PriceDataset;
import jp.sf.orangesignal.ta.util.Assert;

@NumberCompressorType(value=CompressType.SUM)
public class TechnicalPriceDataset
extends PriceDataset {
    private static final long serialVersionUID = -3475688299719279063L;
    protected Candlestick[] candlestick;
    @NumberItem
    @NumberCompressorType(value=CompressType.FIRST)
    protected Number[] technicalOpen;
    @NumberItem
    @NumberCompressorType(value=CompressType.HIGHEST)
    protected Number[] technicalHigh;
    @NumberItem
    @NumberCompressorType(value=CompressType.LOWEST)
    protected Number[] technicalLow;
    @NumberItem
    @NumberCompressorType(value=CompressType.LAST)
    protected Number[] technicalClose;
    @NumberItem
    @NumberCompressorType(value=CompressType.SUM)
    protected Number[] technicalVolume;

    public TechnicalPriceDataset() {
    }

    public TechnicalPriceDataset(PriceDataset dataset) {
        Assert.notNull(dataset, "Dataset must not be null");
        this.date = dataset.date;
        this.open = dataset.open;
        this.high = dataset.high;
        this.low = dataset.low;
        this.close = dataset.close;
        this.volume = dataset.volume;
        this.candlestick = new CandlestickGenerator().generate(this.date, this.open, this.high, this.low, this.close);
        if (this.open != null) {
            this.technicalOpen = DataConvertUtils.previousIfNull(this.open);
        }
        if (this.high != null) {
            this.technicalHigh = DataConvertUtils.previousIfNull(this.high);
        }
        if (this.low != null) {
            this.technicalLow = DataConvertUtils.previousIfNull(this.low);
        }
        if (this.close != null) {
            this.technicalClose = DataConvertUtils.previousIfNull(this.close);
        }
        if (this.volume != null) {
            this.technicalVolume = DataConvertUtils.zeroIfNull(this.volume);
        }
    }

    public static TechnicalPriceDataset newInstance(Price[] prices) {
        Assert.notEmpty(prices, "Prices must not be empty");
        return new TechnicalPriceDataset(AnnotationParser.parse(prices).build(PriceDataset.class).execute());
    }

    public Candlestick[] getCandlestick() {
        return this.candlestick;
    }

    public Number[] getTechnicalOpen() {
        return this.technicalOpen;
    }

    public Number[] getTechnicalHigh() {
        return this.technicalHigh;
    }

    public Number[] getTechnicalLow() {
        return this.technicalLow;
    }

    public Number[] getTechnicalClose() {
        return this.technicalClose;
    }

    public Number[] getTechnicalVolume() {
        return this.technicalVolume;
    }
}

