/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.util.LinkedList;
import ognl.OgnlRuntime;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DriverManagerUtil;

public class DisposableUtil {
    protected static final LinkedList disposables = new LinkedList();

    public static synchronized void add(Disposable disposable) {
        disposables.add(disposable);
    }

    public static synchronized void remove(Disposable disposable) {
        disposables.remove(disposable);
    }

    public static synchronized void dispose() {
        while (!disposables.isEmpty()) {
            Disposable disposable = (Disposable)disposables.removeLast();
            try {
                disposable.dispose();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        disposables.clear();
        OgnlRuntime.clearCache();
        Logger.dispose();
    }

    public static void deregisterAllDrivers() {
        DriverManagerUtil.deregisterAllDrivers();
    }
}

