/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.filters.CsvNamedValueFilter;
import jp.sf.orangesignal.csv.handlers.BeanListHandlerSupport;

public class BeanListHandler<T>
extends BeanListHandlerSupport<T, BeanListHandler<T>> {
    private String[] includeNames;
    private String[] excludeNames;
    private CsvNamedValueFilter valueFilter;

    public BeanListHandler(Class<T> type) {
        super(type);
    }

    public BeanListHandler<T> includes(String ... names) {
        if (this.excludeNames != null && this.excludeNames.length > 0) {
            throw new IllegalArgumentException("Only includes or excludes may be specified.");
        }
        this.includeNames = names;
        return this;
    }

    public BeanListHandler<T> excludes(String ... names) {
        if (this.includeNames != null && this.includeNames.length > 0) {
            throw new IllegalArgumentException("Only includes or excludes may be specified.");
        }
        this.excludeNames = names;
        return this;
    }

    private boolean isTargetName(String name) {
        if (this.excludeNames != null && this.excludeNames.length > 0) {
            String[] stringArray = this.excludeNames;
            int n = this.excludeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String propertyName = stringArray[n2];
                if (propertyName.equals(name)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (this.includeNames != null && this.includeNames.length > 0) {
            String[] stringArray = this.includeNames;
            int n = this.includeNames.length;
            int n3 = 0;
            while (n3 < n) {
                String propertyName = stringArray[n3];
                if (propertyName.equals(name)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        return true;
    }

    public BeanListHandler<T> format(String name, Format format) {
        this.setValueParser(name, format);
        this.setValueFormatter(name, format);
        return this;
    }

    public BeanListHandler<T> filter(CsvNamedValueFilter filter) {
        this.valueFilter = filter;
        return this;
    }

    @Override
    public List<T> load(CsvReader reader) throws IOException {
        List<String> values;
        List<String> columnNames = reader.readValues();
        if (columnNames == null) {
            throw new IOException("No header is available");
        }
        ArrayList results = new ArrayList();
        int columnCount = columnNames.size();
        int offset = 0;
        while ((values = reader.readValues()) != null && (this.limit <= 0 || results.size() < this.limit)) {
            if (this.valueFilter != null && !this.valueFilter.accept(columnNames, values)) continue;
            if (this.beanFilter == null && offset < this.offset) {
                ++offset;
                continue;
            }
            Object bean = this.createBean();
            int len = Math.min(columnCount, values.size());
            int pos = 0;
            while (pos < len) {
                Field f;
                Object o;
                String name = columnNames.get(pos);
                if (this.isTargetName(name) && (o = this.stringToObject(f = BeanListHandler.getField(this.getType(), name), values.get(pos))) != null) {
                    BeanListHandler.setFieldValue(bean, f, o);
                }
                ++pos;
            }
            if (this.beanFilter != null) {
                if (!this.beanFilter.accept(bean)) continue;
                if (offset < this.offset) {
                    ++offset;
                    continue;
                }
            }
            results.add(bean);
        }
        return results;
    }

    @Override
    public void save(List<T> list, CsvWriter writer) throws IOException {
        ArrayList<String> columnNames = new ArrayList<String>();
        Field[] fieldArray = this.getType().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            String name = f.getName();
            if (this.isTargetName(name)) {
                columnNames.add(name);
            }
            ++n2;
        }
        writer.writeValues(columnNames);
        int columnCount = columnNames.size();
        for (T bean : list) {
            if (bean == null) {
                writer.writeValues(null);
                continue;
            }
            if (this.beanFilter != null && !this.beanFilter.accept(bean)) continue;
            String[] values = new String[columnCount];
            int i = 0;
            while (i < columnCount) {
                String name = (String)columnNames.get(i);
                if (name != null) {
                    Field f = BeanListHandler.getField(bean.getClass(), name);
                    values[i] = this.objectToString(name, BeanListHandler.getFieldValue(bean, f));
                }
                ++i;
            }
            List<String> _values = Arrays.asList(values);
            if (this.valueFilter != null && !this.valueFilter.accept(columnNames, _values)) continue;
            writer.writeValues(_values);
        }
    }
}

