/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading.backtest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sf.orangesignal.trading.VirtualTrader;
import jp.sf.orangesignal.trading.backtest.BacktestException;
import jp.sf.orangesignal.trading.backtest.BacktesterEvent;
import jp.sf.orangesignal.trading.backtest.BacktesterListener;
import jp.sf.orangesignal.trading.backtest.TradingStrategyContextImpl;
import jp.sf.orangesignal.trading.data.Dataset;
import jp.sf.orangesignal.trading.data.DatasetLoader;
import jp.sf.orangesignal.trading.order.OrderTiming;
import jp.sf.orangesignal.trading.stats.Stats;
import jp.sf.orangesignal.trading.stats.Summary;
import jp.sf.orangesignal.trading.strategy.TradingStrategy;
import jp.sf.orangesignal.trading.strategy.TradingStrategyContextAware;

public class Backtester
implements Serializable {
    private static final long serialVersionUID = -3957134051507112760L;
    private List<BacktesterListener> listeners = new ArrayList<BacktesterListener>(1);
    private DatasetLoader datasetLoader;
    private Date startDate;
    private Date endDate;
    private Map<String, String> symbols;
    private List<TradingStrategy> strategies;
    private VirtualTrader trader;
    private OrderTiming defaultOrderTiming = OrderTiming.NEXT_OPEN;

    public void addBacktesterListener(BacktesterListener listener) {
        this.listeners.add(listener);
    }

    public void removeBacktesterListener(BacktesterListener listener) {
        this.listeners.remove(listener);
    }

    public DatasetLoader getDatasetLoader() {
        return this.datasetLoader;
    }

    public void setDatasetLoader(DatasetLoader datasetLoader) {
        this.datasetLoader = datasetLoader;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Map<String, String> getSymbols() {
        return this.symbols;
    }

    public void setSymbols(Map<String, String> symbolMap) {
        this.symbols = symbolMap;
    }

    public List<TradingStrategy> getStrategies() {
        return this.strategies;
    }

    public void setStrategies(List<TradingStrategy> strategies) {
        this.strategies = strategies;
    }

    public VirtualTrader getTrader() {
        return this.trader;
    }

    public void setTrader(VirtualTrader trader) {
        this.trader = trader;
    }

    public OrderTiming getDefaultOrderTiming() {
        return this.defaultOrderTiming;
    }

    public void setDefaultOrderTiming(OrderTiming defaultOrderTiming) {
        this.defaultOrderTiming = defaultOrderTiming;
    }

    public double getInitialCapital() {
        return this.trader.getInitialCapital();
    }

    public Summary backtest() throws BacktestException {
        int max = this.symbols.size();
        int count = 0;
        LinkedHashMap<String, Stats> statsMap = new LinkedHashMap<String, Stats>(max + 1, 1.0f);
        for (Map.Entry<String, String> entry : this.symbols.entrySet()) {
            String symbol = entry.getKey();
            Dataset dataset = this.datasetLoader.load(symbol);
            dataset.setSymbolName(entry.getValue());
            HashMap<String, Dataset> datasetMap = new HashMap<String, Dataset>(2, 1.0f);
            datasetMap.put(symbol, dataset);
            this.trader.setDatasetMap(datasetMap);
            BacktesterEvent event = new BacktesterEvent(this, max, ++count, symbol, dataset.getSymbolName(), null);
            for (BacktesterListener listener : this.listeners) {
                listener.backtestStart(event);
            }
            this.trader.reset();
            if (this.strategies == null) continue;
            int start = dataset.defaultIndexOf(this.startDate);
            int end = dataset.defaultLastIndexOf(this.endDate);
            TradingStrategyContextImpl context = new TradingStrategyContextImpl();
            for (TradingStrategy strategy : this.strategies) {
                strategy.setTrader(this.trader);
                strategy.setDefaultOrderTiming(this.defaultOrderTiming);
                strategy.setSymbol(symbol);
                strategy.setDataset(dataset);
                strategy.setStartDataIndex(start);
                strategy.setEndDataIndex(end);
                if (strategy instanceof TradingStrategyContextAware) {
                    ((TradingStrategyContextAware)((Object)strategy)).setTradingStrategyContext(context);
                }
                strategy.prepare();
            }
            Date[] date = dataset.getDate();
            block5: for (int i = start; i <= end; ++i) {
                for (TradingStrategy strategy : this.strategies) {
                    strategy.setCurrentDataIndex(i);
                    strategy.setDate(date[i]);
                    try {
                        if (!strategy.execute()) continue;
                        continue block5;
                    }
                    catch (Exception e) {
                        throw new BacktestException(e.getMessage(), e);
                    }
                }
            }
            for (TradingStrategy strategy : this.strategies) {
                strategy.close();
                if (strategy instanceof TradingStrategyContextAware) {
                    ((TradingStrategyContextAware)((Object)strategy)).setTradingStrategyContext(null);
                }
                strategy.setDataset(null);
                strategy.setSymbol(null);
                strategy.setDefaultOrderTiming(null);
                strategy.setTrader(null);
            }
            context.clear();
            Stats stats = new Stats(this.trader.getPositions(), this.trader.getInitialCapital(), dataset, start, end);
            statsMap.put(symbol, stats);
            event = new BacktesterEvent(this, max, count, symbol, dataset.getSymbolName(), stats);
            for (BacktesterListener listener : this.listeners) {
                listener.backtestProcessed(event);
            }
        }
        return new Summary(statsMap, this);
    }
}

