/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading.data;

import jp.sf.orangesignal.ta.data.DatasetSource;
import jp.sf.orangesignal.ta.data.MergeGapFillType;
import jp.sf.orangesignal.ta.data.MergeMatchType;
import jp.sf.orangesignal.ta.data.annotation.AnnotationParser;
import jp.sf.orangesignal.ta.data.model.Margin;
import jp.sf.orangesignal.ta.data.model.Price;
import jp.sf.orangesignal.ta.data.model.StockSplit;
import jp.sf.orangesignal.ta.util.Assert;

abstract class DatasetGenerator {
    DatasetGenerator() {
    }

    public static <T> T generate(Class<? extends T> datasetClass, Price[] prices, Margin[] margins, StockSplit[] splits, boolean calcSplit) {
        Assert.notNull(datasetClass, (String)"Dataset class must not be null");
        Assert.notEmpty((Object[])prices, (String)"Prices must not be empty");
        DatasetSource source = AnnotationParser.parse((Object[])prices);
        if (splits != null && splits.length > 0) {
            source.merge(AnnotationParser.parse((Object[])splits), MergeMatchType.CURRENT);
            if (calcSplit) {
                source.split("split", new String[]{"open", "high", "low", "close"});
            }
        }
        if (margins != null && margins.length > 0) {
            source.merge(AnnotationParser.parse((Object[])margins), MergeMatchType.CURRENT, MergeGapFillType.PREVIOUS, null);
        }
        return (T)source.build(datasetClass).execute();
    }
}

