/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading.strategy;

import java.util.Date;
import java.util.LinkedList;
import jp.sf.orangesignal.ta.candle.Candlestick;
import jp.sf.orangesignal.trading.MarketPositionType;
import jp.sf.orangesignal.trading.Position;
import jp.sf.orangesignal.trading.Trader;
import jp.sf.orangesignal.trading.commission.Commission;
import jp.sf.orangesignal.trading.data.Dataset;
import jp.sf.orangesignal.trading.order.CurrentCloseOrder;
import jp.sf.orangesignal.trading.order.NextCloseOrder;
import jp.sf.orangesignal.trading.order.NextLimitOrder;
import jp.sf.orangesignal.trading.order.NextOpenOrder;
import jp.sf.orangesignal.trading.order.NextStopOrder;
import jp.sf.orangesignal.trading.order.Order;
import jp.sf.orangesignal.trading.order.OrderTiming;
import jp.sf.orangesignal.trading.order.OrderType;
import jp.sf.orangesignal.trading.strategy.TradingStrategy;

public abstract class AbstractTradingStrategy
implements TradingStrategy {
    private Trader trader;
    private OrderTiming defaultOrderTiming = OrderTiming.NEXT_CLOSE;
    private String symbol;
    private Dataset dataset;
    private int startDataIndex;
    private int endDataIndex;
    private int currentDataIndex;
    private Date currentDate;

    public final Trader getTrader() {
        return this.trader;
    }

    @Override
    public final void setTrader(Trader trader) {
        this.trader = trader;
    }

    public final OrderTiming getDefaultOrderTiming() {
        return this.defaultOrderTiming;
    }

    @Override
    public final void setDefaultOrderTiming(OrderTiming defaultOrderTiming) {
        this.defaultOrderTiming = defaultOrderTiming;
    }

    public final String getSymbol() {
        return this.symbol;
    }

    @Override
    public final void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public final Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public final void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public final int getStartDataIndex() {
        return this.startDataIndex;
    }

    @Override
    public final void setStartDataIndex(int index) {
        this.startDataIndex = index;
    }

    public final int getEndDataIndex() {
        return this.endDataIndex;
    }

    @Override
    public final void setEndDataIndex(int index) {
        this.endDataIndex = index;
    }

    public final int getCurrentDataIndex() {
        return this.currentDataIndex;
    }

    @Override
    public final void setCurrentDataIndex(int index) {
        this.currentDataIndex = index;
    }

    public final Date getDate() {
        return this.currentDate;
    }

    @Override
    public final void setDate(Date date) {
        this.currentDate = date;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void close() {
    }

    public final Number getOpen() {
        return this.dataset.getOpen()[this.currentDataIndex];
    }

    public final Number getHigh() {
        return this.dataset.getHigh()[this.currentDataIndex];
    }

    public final Number getLow() {
        return this.dataset.getLow()[this.currentDataIndex];
    }

    public final Number getClose() {
        return this.dataset.getClose()[this.currentDataIndex];
    }

    public final Number getVolume() {
        return this.dataset.getVolume()[this.currentDataIndex];
    }

    public final Candlestick getCandlestick() {
        return this.dataset.getCandlestick()[this.currentDataIndex];
    }

    public final Position getCurrentPosition() {
        return this.trader.getCurrentPosition(this.symbol);
    }

    public final LinkedList<Position> getCurrentPositions() {
        return this.trader.getCurrentPositions(this.symbol);
    }

    public final int getCurrentEntries() {
        return this.getCurrentPositions().size();
    }

    public final Date getEntryDate() {
        Position position = this.getCurrentPosition();
        if (position == null) {
            return null;
        }
        return position.getEntryDate();
    }

    public final double getEntryPrice() {
        Position position = this.getCurrentPosition();
        if (position == null) {
            return 0.0;
        }
        return position.getEntryPrice();
    }

    public final MarketPositionType getMarketPositionType() {
        return this.trader.getMarketPositionType(this.symbol);
    }

    public Commission getCommission() {
        return this.trader.getCommission();
    }

    @Override
    public String getStrategyName() {
        return this.getClass().getSimpleName();
    }

    protected final void buy(Order order) {
        this.trader.buy(order);
    }

    protected final void sellShort(Order order) {
        this.trader.sellShort(order);
    }

    protected final void sell(Order order) {
        this.trader.sell(order);
    }

    protected final void buyToCover(Order order) {
        this.trader.buyToCover(order);
    }

    protected final Order createOrder(String label, int quantity, OrderTiming timing, double price, Integer findId, String findLabel) {
        if (price == 0.0 && timing.getOrderType() != OrderType.MARKET) {
            throw new IllegalArgumentException();
        }
        if (price != 0.0 && timing.getOrderType() == OrderType.MARKET) {
            throw new IllegalArgumentException();
        }
        switch (timing) {
            case CURRENT_CLOSE: {
                return new CurrentCloseOrder(this.symbol, label, this.currentDate, quantity, findId, findLabel);
            }
            case NEXT_OPEN: {
                return new NextOpenOrder(this.symbol, label, this.currentDate, quantity, findId, findLabel);
            }
            case NEXT_CLOSE: {
                return new NextCloseOrder(this.symbol, label, this.currentDate, quantity, findId, findLabel);
            }
            case NEXT_LIMIT: {
                return new NextLimitOrder(this.symbol, label, this.currentDate, price, quantity, findId, findLabel);
            }
            case NEXT_STOP: {
                return new NextStopOrder(this.symbol, label, this.currentDate, price, quantity, findId, findLabel);
            }
        }
        throw new IllegalArgumentException("Unknown OrderTiming");
    }
}

