/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading.strategy.systems;

import java.util.Map;
import jp.sf.orangesignal.ta.Bands5;
import jp.sf.orangesignal.ta.CrossSignal;
import jp.sf.orangesignal.ta.FourPrice;
import jp.sf.orangesignal.ta.TechnicalAnalysis;
import jp.sf.orangesignal.trading.data.Dataset;
import jp.sf.orangesignal.trading.order.OrderTiming;
import jp.sf.orangesignal.trading.strategy.TradingStrategySupport;

public class BollingerBandsLongEntry
extends TradingStrategySupport {
    private FourPrice price = FourPrice.CLOSE;
    private int period = 20;
    private int num = 2;
    protected Number[] bb;
    protected CrossSignal[] cross;

    public FourPrice getPrice() {
        return this.price;
    }

    public void setPrice(FourPrice price) {
        this.price = price;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    @Override
    public void prepare() {
        Dataset dataset = this.getDataset();
        Number[] high = dataset.getTechnicalHigh();
        Number[] low = dataset.getTechnicalLow();
        Number[] close = dataset.getTechnicalClose();
        Map map = TechnicalAnalysis.bbands((Number[])high, (Number[])low, (Number[])close, (int)this.period, (double)this.num);
        this.bb = (Number[])map.get(Bands5.LOWER_BAND1);
        Number[] price = this.getDataset().getTechnicalPrice(this.price);
        this.cross = TechnicalAnalysis.cross((Number[])price, (Number[])this.bb);
    }

    @Override
    public boolean execute() {
        int i = this.getCurrentDataIndex();
        if (this.cross[i] != null && this.cross[i] == CrossSignal.GOLDEN_CROSS) {
            this.buy(this.getStrategyName(), OrderTiming.NEXT_STOP, this.bb[i].doubleValue());
        }
        return false;
    }

    @Override
    public void close() {
        this.bb = null;
        this.cross = null;
    }
}

