/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.OutputStream;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;

public class PostLzsEncoder
implements PostLzssEncoder {
    private static final int DictionarySize = 2048;
    private static final int MaxMatch = 17;
    private static final int Threshold = 2;
    private static final int PositionBits = Bits.len(2047);
    private static final int LengthBits = Bits.len(15);
    private BitOutputStream out;
    private int position;
    private int matchLength;

    private PostLzsEncoder() {
    }

    public PostLzsEncoder(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        this.out = out instanceof BitOutputStream ? (BitOutputStream)out : new BitOutputStream(out);
        this.position = 0;
        this.matchLength = 0;
    }

    public void writeCode(int code) throws IOException {
        if (code < 256) {
            this.out.writeBit(1);
            this.out.writeBits(8, code);
            ++this.position;
        } else {
            this.out.writeBit(0);
            this.matchLength = code - 256;
        }
    }

    public void writeOffset(int offset) throws IOException {
        int pos = this.position - offset - 1 - 17 & 0x7FF;
        this.position += this.matchLength + 2;
        this.out.writeBits(PositionBits, pos);
        this.out.writeBits(LengthBits, this.matchLength);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
        this.out = null;
    }

    public int getDictionarySize() {
        return 2048;
    }

    public int getMaxMatch() {
        return 17;
    }

    public int getThreshold() {
        return 2;
    }
}

