/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.sf.orangesignal.csv.CsvListHandler;
import jp.sf.orangesignal.csv.filters.BeanFilter;
import jp.sf.orangesignal.csv.handlers.CsvValueConverter;
import jp.sf.orangesignal.csv.handlers.SimpleCsvValueConverter;

public abstract class BeanListHandlerSupport<T, H extends BeanListHandlerSupport<T, H>>
implements CsvListHandler<T> {
    private Class<T> type;
    private Map<String, Format> valueParserMapping = new HashMap<String, Format>();
    private Map<Object, Format> valueFormatterMapping = new HashMap<Object, Format>();
    private CsvValueConverter valueConverter = new SimpleCsvValueConverter();
    protected BeanFilter beanFilter;
    protected int offset;
    protected int limit;

    protected BeanListHandlerSupport(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        this.type = type;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setValueParserMapping(Map<String, Format> valueParserMapping) {
        if (valueParserMapping == null) {
            throw new IllegalArgumentException("CSV value parser mapping must not be null");
        }
        this.valueParserMapping = valueParserMapping;
    }

    public H valueParserMapping(Map<String, Format> valueParserMapping) {
        this.setValueParserMapping(valueParserMapping);
        return (H)this;
    }

    public void setValueFormatterMapping(Map<Object, Format> valueFormatterMapping) {
        if (valueFormatterMapping == null) {
            throw new IllegalArgumentException("CSV value formatter mapping must not be null");
        }
        this.valueFormatterMapping = valueFormatterMapping;
    }

    public H valueFormatterMapping(Map<Object, Format> valueFormatterMapping) {
        this.setValueFormatterMapping(valueFormatterMapping);
        return (H)this;
    }

    public void setValueConverter(CsvValueConverter valueConverter) {
        if (valueConverter == null) {
            throw new IllegalArgumentException("CsvValueConverter must not be null");
        }
        this.valueConverter = valueConverter;
    }

    public H valueConverter(CsvValueConverter valueConverter) {
        this.setValueConverter(valueConverter);
        return (H)this;
    }

    public H converter(CsvValueConverter converter) {
        return this.valueConverter(converter);
    }

    public CsvValueConverter getConverter() {
        return this.valueConverter;
    }

    public H filter(BeanFilter beanFilter) {
        this.beanFilter = beanFilter;
        return (H)this;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public H offset(int offset) {
        this.setOffset(offset);
        return (H)this;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public H limit(int limit) {
        this.setLimit(limit);
        return (H)this;
    }

    protected void setValueParser(String field, Format parser) {
        Format _parser = this.valueParserMapping.get(field);
        if (_parser != null) {
            this.valueParserMapping.put(field, BeanListHandlerSupport.mergeFormatPattern(_parser, parser));
        } else {
            this.valueParserMapping.put(field, parser);
        }
    }

    protected void setValueFormatter(Object column, Format formatter) {
        this.valueFormatterMapping.put(column, formatter);
    }

    protected T createBean() throws IOException {
        try {
            return this.type.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IOException("Cannot create " + this.type.getName() + ": " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new IOException("Cannot create " + this.type.getName() + ": " + e.getMessage(), e);
        }
    }

    protected Map<String, Object[]> createFieldAndColumnsMap(Map<?, String> map) {
        HashMap<String, Object[]> results = new HashMap<String, Object[]>();
        for (Field f : this.type.getDeclaredFields()) {
            String fieldName = f.getName();
            ArrayList list = new ArrayList();
            for (Map.Entry<?, String> e : map.entrySet()) {
                if (!fieldName.equals(e.getValue())) continue;
                list.add(e.getKey());
            }
            if (list.size() <= 0) continue;
            results.put(fieldName, list.toArray());
        }
        return results;
    }

    protected Object stringToObject(Field field, String value) {
        Format format = this.valueParserMapping.get(field.getName());
        if (format != null) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            try {
                return format.parseObject(value);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Unable to parse the %s: %s", field.getName(), value), e);
            }
        }
        return this.valueConverter.convert(value, field.getType());
    }

    protected String objectToString(Object column, Object obj) {
        Format format = this.valueFormatterMapping.get(column);
        if (format != null) {
            if (obj == null) {
                return null;
            }
            return format.format(obj);
        }
        return this.valueConverter.convert(obj);
    }

    public static Field getField(Class<?> type, String name) throws IOException {
        try {
            return type.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new IOException("Field " + name + " not found in " + type.getName() + ": " + e.getMessage(), e);
        }
    }

    public static void setFieldValue(Object bean, Field field, Object value) throws IOException {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(bean, value);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Cannot set " + field.getName() + ": " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Cannot set " + field.getName() + ": " + e.getMessage(), e);
        }
    }

    public static Object getFieldValue(Object bean, Field field) throws IOException {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return field.get(bean);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Cannot get " + field.getName() + ": " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Cannot get " + field.getName() + ": " + e.getMessage(), e);
        }
    }

    private static Format mergeFormatPattern(Format format, Format ... formats) {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(BeanListHandlerSupport.getFormatPattern(format));
            for (Format fmt : formats) {
                buf.append(BeanListHandlerSupport.getFormatPattern(fmt));
            }
            Format result = (Format)format.clone();
            result.getClass().getMethod("applyPattern", String.class).invoke((Object)result, buf.toString());
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static String getFormatPattern(Format format) {
        try {
            return (String)format.getClass().getMethod("toPattern", new Class[0]).invoke((Object)format, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

