using System;
using System.Collections.Generic;
using System.Text;
using System.Data.Odbc;
using System.Data.Common;

namespace Oratorio
{
	public class DatabaseContextOdbcH2 : DatabaseContextOdbc
	{
		public DatabaseContextOdbcH2(OdbcConnection connection)
            : base(connection)
        {
            _productType = ProductTypes.H2;
            _connection = connection;
        }
		public override string GetCurrentSchema()
		{
			string query = "SELECT SCHEMA()";
			using (DbDataReader reader = CreateCommand(query).ExecuteReader())
			{
				if (!reader.Read())
				{
					throw new NotSupportedException();
				}
				_currentSchemaName = reader.GetString(0);
			}
			return _currentSchemaName;
		}
        public override string[] GetSchemaList()
		{
			string query = "SELECT schema_name FROM INFORMATION_SCHEMA.SCHEMATA ORDER BY schema_name";
			using (DbDataReader reader = CreateCommand(query).ExecuteReader())
			{
				List<string> resultList = new List<string>();
				while (reader.Read())
				{
					resultList.Add(reader.GetString(0));
				}
				return resultList.ToArray();
			}
		}
		
	}
}
