using System;
using System.Collections.Generic;
using System.Text;

namespace Oratorio
{
    public class DatabaseScriptGenerator
    {
        private DatabaseContextCommon _database;

        public DatabaseContextCommon Database
        {
            get { return _database; }
        }

        public DatabaseScriptGenerator(DatabaseContextCommon database)
        {
            _database = database;
        }

        public string GetCreateTableScript(string catalog, string schema, string table)
        {
            StringBuilder builder = new StringBuilder();
            StringBuilder keyBuffer = new StringBuilder();

            List<DatabaseColumn> columns = new List<DatabaseColumn>();
            _database.GetTableColumnList(catalog, schema, table, columns);

            foreach (DatabaseColumn column in columns)
            {
                if (builder.Length > 0)
                {
                    builder.Append(",\r\n");
                }
                builder.Append("\t");
                string columnName = column.ColumnName;
                columnName = columnName.ToLower();
                builder.Append(columnName);
                builder.Append(" ");
				builder.Append(column.TypeAndSize);
                if (column.TypeLength != null)
                {
                    builder.Append("(");
                    builder.Append(column.TypeLength);
                    builder.Append(")");
                }
				if (!column.IsNullable)
				{
					builder.Append(" NOT NULL");
				}
				if (column.IsKey)
                {
                    if (keyBuffer.Length > 0)
                    {
                        keyBuffer.Append(",\r\n\t\t");
                    }
                    else
                    {
                        keyBuffer.Append("\t\t");
                    }
                    keyBuffer.Append(columnName);
                }
            }
            string primaryKey = "";
            if (keyBuffer.Length > 0)
            {
                builder.Append(",");
                primaryKey = "\tPRIMARY KEY\r\n\t(\r\n" + keyBuffer + "\r\n\t)\r\n";
            }
            table = table.ToLower();
            string sColumns = builder.ToString();
            string result = "CREATE TABLE " + table + "\r\n(\r\n" + sColumns + "\r\n" + primaryKey + ")\r\n";
            return result;
        }

        public string GetSelectScript(string catalog, string schema, string table)
        {
            StringBuilder builder = new StringBuilder();

            List<DatabaseColumn> columns = new List<DatabaseColumn>();
            _database.GetTableColumnList(catalog, schema, table, columns);

            foreach (DatabaseColumn column in columns)
            {
                if (builder.Length > 0)
                {
                    builder.Append(",\r\n");
                }
                builder.Append("\t");
                string columnName = column.ColumnName;
                columnName = columnName.ToLower();
                builder.Append(columnName);
            }
            table = table.ToLower();
            string sColumns = builder.ToString();
            string result = "SELECT\r\n" + sColumns + "\r\nFROM\r\n\t" + table + "\r\n";
            return result;
        }

        public string GetSelectAsteriskScript(string catalog, string schema, string table)
        {
            table = table.ToLower();
            string result = "SELECT * FROM " + table;
            return result;
        }

        public string GetSelectWhereScript(string catalog, string schema, string table)
        {
            StringBuilder builder = new StringBuilder();

            List<DatabaseColumn> columns = new List<DatabaseColumn>();
            _database.GetTableColumnList(catalog, schema, table, columns);

            StringBuilder keyBuffer = new StringBuilder();
            StringBuilder orderBuffer = new StringBuilder();
            foreach (DatabaseColumn column in columns)
            {
                if (builder.Length > 0)
                {
                    builder.Append(",\r\n");
                }
                builder.Append("\t");
                string columnName = column.ColumnName;
                columnName = columnName.ToLower();
                builder.Append(columnName);
                if (column.IsKey)
                {
                    if (keyBuffer.Length > 0)
                    {
                        keyBuffer.Append("\r\n\tAND ");
                        orderBuffer.Append(",\r\n\t");
                    }
                    else
                    {
                        keyBuffer.Append("\t");
                        orderBuffer.Append("\t");
                    }
                    keyBuffer.Append(columnName);
                    keyBuffer.Append(" = ?");
                    orderBuffer.Append(columnName);
                }
            }

            table = table.ToLower();
            string sColumns = builder.ToString();
            string result = "SELECT\r\n" + sColumns + "\r\nFROM\r\n\t" + table + "\r\n";
            if (keyBuffer.Length > 0)
            {
                result += "WHERE\r\n" + keyBuffer.ToString() + "\r\n";
                result += "ORDER BY\r\n" + orderBuffer.ToString() + "\r\n";
            }

            return result;
        }

        public string GetUpdateScript(string catalog, string schema, string table)
        {
            StringBuilder builder = new StringBuilder();

            List<DatabaseColumn> columns = new List<DatabaseColumn>();
            _database.GetTableColumnList(catalog, schema, table, columns);

            StringBuilder keyBuffer = new StringBuilder();
            foreach (DatabaseColumn column in columns)
            {
                if (builder.Length > 0)
                {
                    builder.Append(",\r\n");
                }
                builder.Append("\t");
                string columnName = column.ColumnName;
                columnName = columnName.ToLower();
                builder.Append(columnName);
                builder.Append(" = ?");
                if (column.IsKey)
                {
                    if (keyBuffer.Length > 0)
                    {
                        keyBuffer.Append("\r\n\tAND ");
                    }
                    else
                    {
                        keyBuffer.Append("\t");
                    }
                    keyBuffer.Append(columnName);
                    keyBuffer.Append(" = ?");
                }
            }

            table = table.ToLower();
            string sColumns = builder.ToString();
            string result = "UPDATE " + table + " SET\r\n" + sColumns + "\r\n";
            if (keyBuffer.Length > 0)
            {
                result += "WHERE\r\n" + keyBuffer.ToString() + "\r\n";
            }

            return result;
        }

        public string GetDeleteScript(string catalog, string schema, string table)
        {
            List<DatabaseColumn> columns = new List<DatabaseColumn>();
            _database.GetTableColumnList(catalog, schema, table, columns);

            StringBuilder keyBuffer = new StringBuilder();
            foreach (DatabaseColumn column in columns)
            {
                string columnName = column.ColumnName;
                columnName = columnName.ToLower();
                if (column.IsKey)
                {
                    if (keyBuffer.Length > 0)
                    {
                        keyBuffer.Append("\r\n\tAND ");
                    }
                    else
                    {
                        keyBuffer.Append("\t");
                    }
                    keyBuffer.Append(columnName);
                    keyBuffer.Append(" = ?");
                }
            }

            table = table.ToLower();
            string result = "DELETE FROM " + table + "";
            if (keyBuffer.Length > 0)
            {
                result += "\r\nWHERE\r\n" + keyBuffer.ToString() + "\r\n";
            }

            return result;
        }

        public string GetInsertScript(string catalog, string schema, string table)
        {
            StringBuilder builder = new StringBuilder();

            List<DatabaseColumn> columns = new List<DatabaseColumn>();
            _database.GetTableColumnList(catalog, schema, table, columns);

            StringBuilder valueBuilder = new StringBuilder("");
            foreach (DatabaseColumn column in columns)
            {
                if (builder.Length > 0)
                {
                    builder.Append(",\r\n");
                    valueBuilder.Append(",\r\n");
                }
                builder.Append("\t");
                valueBuilder.Append("\t");
                string columnName = column.ColumnName;
                columnName = columnName.ToLower();
                builder.Append(columnName);
                valueBuilder.Append("?");
            }

            table = table.ToLower();
            string sColumns = builder.ToString();
            string result = "INSERT INTO " + table + "\r\n(\r\n" + sColumns + "\r\n";
            result += ")\r\nVALUES\r\n(";
            result += "\r\n";
            result += valueBuilder.ToString();
            result += "\r\n)\r\n";

            return result;
        }

        public string GetDropScript(string catalog, string schema, string table)
        {
            StringBuilder builder = new StringBuilder();

            builder.Append("DROP TABLE " + table);

            return builder.ToString();
        }

    }
}
