using System;
using System.Collections.Generic;
using System.Text;

//Setting.csNXSettingsProviderw肵Ă܂B
//ӁFSystem.configurationW[QƐݒŒǉKv܂B
namespace Oratorio.Properties
{
    using System;
    using System.Configuration;
    using System.Xml;
    using System.IO;
    using System.Reflection;
    using System.Collections.Generic;

    public class ApplicationSettingsProvider : LocalFileSettingsProvider
    {
        #region protected
        protected string _settingFileName;

        protected string _settingFolder;
        protected string _settingNodeName;

        protected const string USER_CONFIG_FILE_NAME = "user.config";
        protected ApplicationSettingsConverter _utility = new ApplicationSettingsConverter();
        #endregion

        public string SettingPath
        {
            get { return Path.Combine(_settingFolder, _settingFileName); }
        }

        public string SettingFolder
        {
            get { return _settingFolder; }
            set { _settingFolder = value; }
        }
	
        public string SettingFileName
        {
            get { return _settingFileName; }
            set { _settingFileName = value; }
        }

        public string SettingNodeName
        {
            get { return _settingNodeName; }
            set { _settingNodeName = value; }
        }
	
        public ApplicationSettingsProvider()
        {

            Assembly exeAssembly = Assembly.GetEntryAssembly();
            object[] customAttributes = exeAssembly.GetCustomAttributes(typeof(AssemblyCompanyAttribute), false);
            string companyName = ((AssemblyCompanyAttribute)customAttributes[0]).Company;
            customAttributes = exeAssembly.GetCustomAttributes(typeof(AssemblyProductAttribute), false);
            string productName = ((AssemblyProductAttribute)customAttributes[0]).Product;
            customAttributes = exeAssembly.GetCustomAttributes(typeof(AssemblyFileVersionAttribute), false);
            string version = ((AssemblyFileVersionAttribute)customAttributes[0]).Version;

            string appDataFolder = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData);
            string confPath = Path.Combine(appDataFolder, companyName);
            confPath = Path.Combine(confPath, productName);
            confPath = Path.Combine(confPath, version.Split(new char[] { '.' })[0] + "." + version.Split(new char[] { '.' })[1]);

            _settingNodeName = GetType().Namespace + ".Settings";
            _settingFolder = confPath;
            _settingFileName = USER_CONFIG_FILE_NAME;
        }

        public override void SetPropertyValues(SettingsContext context, SettingsPropertyValueCollection values)
        {

            IDictionary<string, string> newSettings = new Dictionary<string, string>();
            foreach (SettingsPropertyValue value2 in values)
            {
                SettingsProperty property = value2.Property;
                bool flag = property.Attributes[typeof(UserScopedSettingAttribute)] is UserScopedSettingAttribute;

                if (value2.IsDirty && flag)
                {
                    string serializedValue = string.Empty;
                    if (value2.SerializedValue is String)
                    {
                        serializedValue = _utility.EscapeXmlValue(value2.SerializedValue as string);
                    }
                    else if (property.SerializeAs == SettingsSerializeAs.Binary && value2.SerializedValue is byte[])
                    {
                        serializedValue = Convert.ToBase64String(value2.SerializedValue as byte[]);
                    }
                    newSettings[property.Name] = serializedValue;

                    value2.IsDirty = false;
                }
            }
            if (newSettings.Count > 0)
            {
                XmlDocument document = _utility.ConvertSettingsToXml(newSettings, _settingNodeName);
                string confPath = Path.Combine(_settingFolder, _settingFileName);

                if (!Directory.Exists(_settingFolder))
                {
                    Directory.CreateDirectory(_settingFolder);
                }
                try
                {
                    document.Save(confPath);
                }
                catch (IOException ioe)
                {
                    throw new ConfigurationErrorsException("settings save failed", ioe);
                }
            }
        }
        
        public override SettingsPropertyValueCollection GetPropertyValues(SettingsContext context, SettingsPropertyCollection properties)
        {
            SettingsPropertyValueCollection values = base.GetPropertyValues(context, properties);

            string confPath = Path.Combine(_settingFolder, _settingFileName);
            if (!File.Exists(confPath))
            {
                return values;
            }

            XmlDocument document = new XmlDocument();
            try
            {
                document.Load(confPath);
            }
            catch (XmlException xe)
            {
                throw new ConfigurationErrorsException("settings load failed", xe);
            }
            catch (IOException ioe)
            {
                throw new ConfigurationErrorsException("settings load failed", ioe);
            }

            IDictionary<string, string> settings = null;
            _utility.ConvertXmlToSettings(document, _settingNodeName, out settings);
            foreach (KeyValuePair<string, string> keyVal in settings)
            {
                string keyName = keyVal.Key;
                if (values[keyName] == null)
                {
                    continue;
                }
                string value = keyVal.Value;
                values[keyName].SerializedValue = value;
            }

            return values;
        }

    }
}
