using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace Oratorio
{
	public partial class ScriptFormEditControl : UserControl
	{
		public RichTextBox TextBox
		{
			get { return _textBox; }
		}
	
		public ScriptFormEditControl()
		{
			InitializeComponent();
//            _textBox.AllowDrop = true;
		}

		private void _textBox_KeyDown(object sender, KeyEventArgs e)
		{
			ScriptForm form = (ScriptForm)this.Parent.Parent.Parent.Parent;
			if (e.KeyCode == Keys.Return && e.Control)
			{
				e.Handled = true;
				form.ExecuteScript();
			}
		}

		private void _textBox_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
		{
		}

		private void _textBox_KeyPress(object sender, KeyPressEventArgs e)
		{
			/*
			ScriptForm form = (ScriptForm)this.Parent.Parent.Parent.Parent;
			if (e.KeyChar == (char)Keys.Return && Control.ModifierKeys == Keys.Control)
			{
				e.Handled = true;
				form.Run();
				//				e.Ca
			}
			 */
		}

		private void ScriptFormEditControl_Load(object sender, EventArgs e)
		{
			Font oldFont = this._textBox.Font;
//			Font font = new Font(FontFamily.GenericMonospace, (float)Math.Ceiling((double)oldFont.Size));
			Font font = new Font(FontFamily.GenericMonospace, oldFont.Size, oldFont.Unit);
			this._textBox.Font = font;
            ProgramUtility.LoadMenuStringsFromResource(_contextMenu.Items, GetType().FullName);
        }

        private void _copyMenuItem_Click(object sender, EventArgs e)
        {
            _textBox.Copy();
        }

        private void _cutMenuItem_Click(object sender, EventArgs e)
        {
            _textBox.Cut();
        }

        private void _pasteMenuItem_Click(object sender, EventArgs e)
        {
            _textBox.Paste();
        }

        private void _selectAllMenuItem_Click(object sender, EventArgs e)
        {
            _textBox.SelectAll();
        }

        private void _deleteMenuItem_Click(object sender, EventArgs e)
        {
            _textBox.SelectedText = "";
        }
	}
}
