using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.IO;
using Microsoft.VisualBasic.FileIO;
using System.Data.Common;

namespace Oratorio
{
	public partial class ScriptFormGridControl : UserControl
	{
        protected volatile bool _cellEdit;

        public DataGridView GridView
		{
			get { return this._dataGridView; }
		}

		private DatabaseExecuter _executer;

		public DatabaseExecuter Executer
		{
			get { return _executer; }
			set { _executer = value; }
		}

		public ScriptFormGridControl()
		{
			InitializeComponent();
		}

		private void _dataGridView_CurrentCellChanged(object sender, EventArgs e)
		{
            ProgramUtility.WriteLine("_dataGridView_CurrentCellChanged");
            return;
            //if (_cellEdit)
            //{
            //    _cellEdit = false;
            //    ProgramUtility.WriteLine("_dataGridView_CurrentCellChanged celledit");
            //    if (_dataGridView.CurrentRow != null)
            //    {
            //        object currentRowView = _dataGridView.CurrentRow.DataBoundItem;
            //        if (currentRowView is DataRowView)
            //        {
            //            ((DataRowView)currentRowView).EndEdit();
            //        }
            //    }
            //    _dataGridView.EndEdit();
            //    try
            //    {
            //        _executer.UpdateDataSet();
            //    }
            //    catch (DatabaseContextException dce)
            //    {
            //        ProgramUtility.ShowError(dce);
            //        return;
            //    }
            //    _rowEdit = false;
            //}
		}

		private void _dataGridView_UserDeletedRow(object sender, DataGridViewRowEventArgs e)
		{
			try
			{
				_executer.UpdateDataSet();
			}
			catch (DatabaseContextException dce)
			{
				ProgramUtility.ShowError(dce);
			}
		}

		private void _dataGridView_CellValueChanged(object sender, DataGridViewCellEventArgs e)
		{
            ProgramUtility.WriteLine("_dataGridView_CellValueChanged");
//            _cellEdit = true;
//            _rowEdit = true;

            if (_dataGridView.CurrentRow != null)
            {
                object currentRowView = _dataGridView.CurrentRow.DataBoundItem;
                if (currentRowView is DataRowView)
                {
                    try
                    {
                        ((DataRowView)currentRowView).EndEdit();
                    }
                    catch (DataException de)
                    {
                        ProgramUtility.ShowError(de);
                        return;
                    }
                }
            }
            _dataGridView.EndEdit();
            try
            {
                _executer.UpdateDataSet();
            }
            catch (DatabaseContextException dce)
            {
                ProgramUtility.ShowError(dce);
                return;
            }
            //if (_executer.Data.Tables[0].Rows.Count > e.RowIndex)
            //{
            //                    _executer.Table.Up
            //                    _dataGridView.Rows[e.RowIndex].Cells[e.ColumnIndex].Value = null;
            //    _dataGridView.EndEdit();
            //                    object value = _dataGridView.Rows[e.RowIndex].Cells[e.ColumnIndex].Value;
            //    if (value == null)
            //    {
            //        ProgramUtility.WriteLine("<null>");
            //    }
            //    else
            //    {
            //        ProgramUtility.WriteLine(value.GetType());
            //    }
            //                    ((DataRowView)_dataGridView.CurrentRow.DataBoundItem).EndEdit();
            //                    _executer.Table.Rows[e.RowIndex].EndEdit();
            //                    _executer.UpdateDataSet();
            //}
		}

		public bool IsCallEditActionEnable(ProgramUtility.CallEditActionModes mode)
		{
			DataGridView gridView = this._dataGridView;

			if (mode == ProgramUtility.CallEditActionModes.COPY)
			{
				if (gridView.SelectedRows.Count > 0)
				{
					return true;
				}
				else if (gridView.SelectedCells.Count == 1)
				{
					return true;
				}
			}
			else if (mode == ProgramUtility.CallEditActionModes.CUT)
			{
				if (gridView.SelectedCells.Count == 1)
				{
					return true;
				}
			}
			else if (mode == ProgramUtility.CallEditActionModes.PASTE)
			{
                //if (gridView.SelectedRows.Count == 1 && gridView.SelectedRows[0].IsNewRow)
                if (gridView.SelectedRows.Count == 1)
                {
					return true;
				}
				if (gridView.SelectedCells.Count == 1)
				{
					return true;
				}
			}
			else if (mode == ProgramUtility.CallEditActionModes.DELETE)
			{
				if (gridView.SelectedRows.Count > 0)
				{
					return true;
				}
				else if (gridView.SelectedCells.Count == 1)
				{
					return true;
				}
			}
			else if (mode == ProgramUtility.CallEditActionModes.SELECT_ALL)
			{
				return true;
			}
			return false;
		}

        public void ImportCsv(TextReader reader, string delimiter)
        {
            TextFieldParser parser = new TextFieldParser(reader);
            parser.SetDelimiters(delimiter);
            int maxColumn = GridView.ColumnCount;
//            DataColumnCollection columns = table.Columns;
            while (!parser.EndOfData)
            {
                string[] textFields = null;
                try
                {
                    textFields = parser.ReadFields();
                }
                catch (MalformedLineException mle)
                {
                    throw new ProgramException("Text parse failed.", mle);
                }
                if (textFields.Length == 0)
                {
                    continue;
                }
                object[] fields = new object[maxColumn];
                Array.Copy(textFields, 0, fields, 0, Math.Min(maxColumn, textFields.Length));

                int maxFields = Math.Min(fields.Length, textFields.Length);
                for (int index = 0; index < maxFields; index++)
                {
                    if (GridView.Columns[index].ValueType == typeof(Decimal))
                    {
                        string text = textFields[index];
                        text = text.Trim();
                        Decimal value;
                        if (Decimal.TryParse(text, out value))
                        {
                            fields[index] = value;
                        }
                        else
                        {
                            fields[index] = DBNull.Value;
                        }
                    }
                    else if (GridView.Columns[index].ValueType == typeof(DateTime))
                    {
                        string text = textFields[index];
                        text = text.Trim();
                        DateTime value;
                        if (DateTime.TryParse(text, out value))
                        {
                            fields[index] = value;
                        }
                        else
                        {
                            fields[index] = DBNull.Value;
                        }

                    }
                }

                try
                {
                    _executer.Table.Rows.Add(fields);
                }
                //catch (DatabaseContextException dce)
                //{
                //    throw new ProgramException("Invalid data.", dce);
                //}
                catch (DataException de)
                {
                    throw new ProgramException("Invalid data.", de);
                }
                catch (ArgumentException ae)
                {
                    throw new ProgramException("Invalid data.", ae);
                }
            }
        }

        public static string GetSelectedDataGridViewText(DataGridView gridView)
        {
            StringBuilder result = new StringBuilder("");
            if (gridView.SelectedRows.Count > 0)
            {
                List<int> rowIndexList = new List<int>();
                foreach (DataGridViewRow row in gridView.SelectedRows)
                {
                    if (row.IsNewRow)
                    {
                        continue;
                    }
                    rowIndexList.Add(row.Index);
                }
                rowIndexList.Sort();
                foreach (int rowNum in rowIndexList)
                {
                    DataGridViewRow row = gridView.Rows[rowNum];
                    bool firstCell = true;
                    foreach (DataGridViewCell cell in row.Cells)
                    {
                        if (firstCell)
                        {
                            firstCell = false;
                        }
                        else
                        {
                            result.Append("\t");
                        }
                        object value = cell.Value;
                        string text = (value == null ? "" : value.ToString());
                        if (text.StartsWith("\""))
                        {
                            text = text.Replace("\"", "\"\"");
                            text = "\"" + text + "\"";
                        }
                        result.Append(text);
                    }
                    result.Append("\r\n");
                }
            }
            else if (gridView.SelectedCells.Count > 0)
            {
                List<DataGridViewCell> cellList = new List<DataGridViewCell>();
                foreach (DataGridViewCell cell in gridView.SelectedCells)
                {
                    cellList.Add(cell);
                }
                cellList.Sort(new ProgramUtility.DataGdidViewCellComparer());
                int beforeRowIndex = -1;
                foreach (DataGridViewCell cell in cellList)
                {
                    if (cell.RowIndex != beforeRowIndex)
                    {
                        if (beforeRowIndex != -1)
                        {
                            result.Append("\r\n");
                        }
                        beforeRowIndex = cell.RowIndex;
                    }
                    else
                    {
                        result.Append("\t");
                    }
                    object value = cell.Value;
                    string text = (value == null ? "" : value.ToString());
                    if (text.StartsWith("\""))
                    {
                        text = text.Replace("\"", "\"\"");
                        text = "\"" + text + "\"";
                    }
                    result.Append(text);
                }
                result.Append("\r\n");
            }
            return result.ToString();
        }

        public void CallEditAction(ProgramUtility.CallEditActionModes mode)
		{
			DataGridView gridView = this._dataGridView;
//			StringBuilder result = new StringBuilder("");
//			result.Append("");

			if (mode == ProgramUtility.CallEditActionModes.COPY)
			{
                string result = GetSelectedDataGridViewText(_dataGridView);
				if (gridView.SelectedCells.Count == 1)
				{
				    object value = gridView.SelectedCells[0].Value;
					if (value != null)
					{
						result = value.ToString();
					}
				}
				if (result.Length > 0)
                {
                    Clipboard.SetText(result);
                }
                else
                {
                    Clipboard.Clear();
                }
                //if (gridView.SelectedRows.Count > 0)
                //{
                //    int maxColumn = gridView.ColumnCount;
                //    List<int> rowIndexList = new List<int>();
                //    foreach (DataGridViewRow row in gridView.SelectedRows)
                //    {
                //        if (row.IsNewRow)
                //        {
                //            continue;
                //        }
                //        rowIndexList.Add(row.Index);
                //    }
                //    rowIndexList.Sort();
                //    foreach (int rowNum in rowIndexList)
                //    {
                //        DataGridViewRow row = gridView.Rows[rowNum];
                //        bool firstCell = true;
                //        foreach (DataGridViewCell cell in row.Cells)
                //        {
                //            if (cell.Selected)
                //            {
                //                if (firstCell)
                //                {
                //                    firstCell = false;
                //                }
                //                else
                //                {
                //                    result.Append("\t");
                //                }
                //                object value = cell.Value;
                //                string text = (value == null? "": value.ToString());
                //                if (text.StartsWith("\""))
                //                {
                //                    text = text.Replace("\"", "\"\"");
                //                    text = "\"" + text + "\"";
                //                }
                //                result.Append(text);
                //            }
                //        }
                //        result.Append("\r\n");
                //    }
                //}
                //else if (gridView.SelectedCells.Count == 1)
                //{
                //    object value = gridView.SelectedCells[0].Value;
                //    if (value != null)
                //    {
                //        result.Append(value.ToString());
                //    }
                //}
                //Clipboard.SetText(result.ToString());
			}
			else if (mode == ProgramUtility.CallEditActionModes.CUT)
			{
				if (gridView.SelectedCells.Count == 1)
				{
                    StringBuilder result = new StringBuilder("");
                    object value = gridView.SelectedCells[0].Value;
					if (value != null)
					{
						result.Append(value.ToString());
					}
					gridView.SelectedCells[0].Value = DBNull.Value;
                    if (result.Length > 0)
                    {
                        Clipboard.SetText(result.ToString());
                    }
                    else
                    {
                        Clipboard.Clear();
                    }
				}
			}
			else if (mode == ProgramUtility.CallEditActionModes.PASTE)
			{
				string clipText = Clipboard.GetText();
                //if (gridView.SelectedRows.Count == 1 && gridView.SelectedRows[0].IsNewRow)
                if (gridView.SelectedRows.Count == 1)
                {
					int beforeIndex = gridView.SelectedRows[0].Index;
					StringReader reader = new StringReader(clipText);
                    //TextFieldParser parser = new TextFieldParser(reader);
                    //parser.SetDelimiters("\t");
                    //int maxColumn = gridView.ColumnCount;
                    //DataColumnCollection columns = _executer.Table.Columns;

					try
					{
						bool bDeleteNewRow = false;
                        int lastRowIndex = _dataGridView.Rows.Count - 1;
                        if (_dataGridView.Rows[lastRowIndex].IsNewRow)
						{
							bDeleteNewRow = true;
						}
						_executer.Table.DefaultView.AllowNew = false;
                        if (bDeleteNewRow && _dataGridView.Rows.Count > lastRowIndex)
						{
                            _dataGridView.Rows.RemoveAt(lastRowIndex);
						}

                        try
                        {
                            //ImportCsv(reader, _executer.Table, "\t");
                            ImportCsv(reader, "\t");

                            //while (!parser.EndOfData)
                            //{
                            //    string[] textFields = parser.ReadFields();
                            //    if (textFields.Length == 0)
                            //    {
                            //        continue;
                            //    }
                            //    object[] fields = new object[maxColumn];
                            //    Array.Copy(textFields, 0, fields, 0, Math.Min(maxColumn, textFields.Length));

                            //    int maxFields = Math.Min(fields.Length, textFields.Length);
                            //    for (int index = 0; index < maxFields; index++)
                            //    {
                            //        if (columns[index].DataType == typeof(Decimal))
                            //        {
                            //            Decimal value;
                            //            if (Decimal.TryParse(textFields[index], out value))
                            //            {
                            //                fields[index] = value;
                            //            }
                            //            else
                            //            {
                            //                fields[index] = DBNull.Value;
                            //            }

                            //        }
                            //        else if (columns[index].DataType == typeof(DateTime))
                            //        {
                            //            DateTime value;
                            //            if (DateTime.TryParse(textFields[index], out value))
                            //            {
                            //                fields[index] = value;
                            //            }
                            //            else
                            //            {
                            //                fields[index] = DBNull.Value;
                            //            }

                            //        }
                            //    }
                            //    try
                            //    {
                            //        _executer.Table.Rows.Add(fields);
                            //    }
                            //    catch (DataException de)
                            //    {
                            //        throw new DatabaseContextException("Invalid data.", de);
                            //    }
                            //    catch (ArgumentException ae)
                            //    {
                            //        throw new DatabaseContextException("Invalid data.", ae);
                            //    }
                            //}

							_executer.UpdateDataSet();
						}
                        catch (ProgramException pe)
                        {
                            ProgramUtility.ShowError(pe);
                        }
                        catch (DatabaseContextException dce)
                        {
                            ProgramUtility.ShowError(dce);
                        }
                        //catch (MalformedLineException mle)
                        //{
                        //    ProgramUtility.ShowError(mle);
                        //}
                        gridView.Select();
                        
						_executer.Table.DefaultView.AllowNew = true;
						if (gridView.Rows.Count > beforeIndex)
						{
							gridView.Rows[beforeIndex].Selected = true;
							gridView.CurrentCell = gridView[0, beforeIndex];
						}
                    }
					finally
					{
						_executer.Table.DefaultView.AllowNew = true;
					}
				}
				else if (gridView.SelectedCells.Count == 1)
				{
					gridView.SelectedCells[0].Value = clipText;
				}
			}
			else if (mode == ProgramUtility.CallEditActionModes.DELETE)
			{
				if (gridView.SelectedRows.Count > 0)
				{
					if (MessageBox.Show(Parent, "Remove record from database?", Application.ProductName, MessageBoxButtons.YesNo) != DialogResult.Yes)
					{
						return;
					}
					int maxColumn = gridView.ColumnCount;
					List<int> rowIndexList = new List<int>();
					foreach (DataGridViewRow row in gridView.SelectedRows)
					{
						if (row.IsNewRow)
						{
							continue;
						}
						rowIndexList.Add(row.Index);
					}
					rowIndexList.Sort();
					for (int rowNum = rowIndexList.Count - 1; rowNum >= 0; rowNum--)
					{
						gridView.Rows.RemoveAt(rowIndexList[rowNum]);
					}
					try
					{
						_executer.UpdateDataSet();
					}
					catch (DatabaseContextException dce)
					{
						ProgramUtility.ShowError(dce);
					}
				}
				else if (gridView.SelectedCells.Count == 1)
				{
					gridView.SelectedCells[0].Value = DBNull.Value;
                    if (_dataGridView.CurrentRow != null)
                    {
                        DataRowView currentRow = (DataRowView)_dataGridView.CurrentRow.DataBoundItem;
                        if (currentRow != null)
                        {
                            currentRow.EndEdit();
                        }
                    }
                    _dataGridView.EndEdit();
                    try
					{
						_executer.UpdateDataSet();
					}
					catch (DatabaseContextException dbce)
					{
						ProgramUtility.ShowError(dbce);
					}
				}
			}
			else if (mode == ProgramUtility.CallEditActionModes.SELECT_ALL)
			{
				gridView.SelectAll();
			}
		}

		private void _dataGridView_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
		{
			if (_dataGridView.Rows[e.RowIndex].IsNewRow || _dataGridView.Rows[e.RowIndex].ErrorText.Length > 0)
			{
				return;
			}
			Rectangle rect = new Rectangle(
				e.RowBounds.Location.X,
				e.RowBounds.Location.Y,
				_dataGridView.RowHeadersWidth - 4,
				e.RowBounds.Height);

			TextRenderer.DrawText(
				e.Graphics,
				(e.RowIndex + 1).ToString(),
				_dataGridView.RowHeadersDefaultCellStyle.Font,
				rect,
				_dataGridView.RowHeadersDefaultCellStyle.ForeColor,
				TextFormatFlags.VerticalCenter | TextFormatFlags.Right);
		}

		private void _selectAllMenuItem_Click(object sender, EventArgs e)
		{
			_dataGridView.SelectAll();
		}

		private void _cutMenuItem_Click(object sender, EventArgs e)
		{
			CallEditAction(ProgramUtility.CallEditActionModes.CUT);
		}

		private void _copyMenuItem_Click(object sender, EventArgs e)
		{
			CallEditAction(ProgramUtility.CallEditActionModes.COPY);

		}

		private void _pasteMenuItem_Click(object sender, EventArgs e)
		{
			CallEditAction(ProgramUtility.CallEditActionModes.PASTE);
		}

		private void _deleteMenuItem_Click(object sender, EventArgs e)
		{
			CallEditAction(ProgramUtility.CallEditActionModes.DELETE);
		}

		private void _copyColumnMenuItem_Click(object sender, EventArgs e)
		{
            if (_dataGridView.SelectedRows.Count > 0)
            {
                StringBuilder builder = new StringBuilder();
                bool first = true;
                foreach (DataGridViewColumn column in _dataGridView.Columns)
                {
                    if (first)
                    {
                        first = false;
                    }
                    else
                    {
                        builder.Append("\t");
                    }
                    builder.Append(column.Name);
                }
                Clipboard.SetText(builder.ToString());
                return;
            }
            else if (_dataGridView.SelectedCells.Count > 0)
            {
                StringBuilder builder = new StringBuilder();
                List<DataGridViewCell> cellList = new List<DataGridViewCell>();
                foreach (DataGridViewCell cell in _dataGridView.SelectedCells)
                {
                    cellList.Add(cell);
                }
                cellList.Sort(new ProgramUtility.DataGdidViewCellComparer());
                int beforeRowIndex = -1;
                foreach (DataGridViewCell cell in cellList)
                {
                    if (cell.RowIndex != beforeRowIndex)
                    {
                        if (beforeRowIndex != -1)
                        {
                            break;
                        }
                        beforeRowIndex = cell.RowIndex;
                    }
                    else
                    {
                        builder.Append("\t");
                    }
                    object value = _dataGridView.Columns[cell.ColumnIndex].Name;
                    string text = (value == null ? "" : value.ToString());
                    builder.Append(text);
                }
                Clipboard.SetText(builder.ToString());
                return;
            }
            else
            {
                DataGridViewCell cell = _dataGridView.CurrentCell;
                if (cell == null)
                {
                    return;
                }
                String columnName = _dataGridView.Columns[cell.ColumnIndex].Name;
                Clipboard.SetText(columnName);
            }
		}

		private void ScriptFormGridControl_Load(object sender, EventArgs e)
		{
            ProgramUtility.LoadMenuStringsFromResource(_contextMenuStrip.Items, GetType().FullName);
        }

		private void _dataGridView_CellValueNeeded(object sender, DataGridViewCellValueEventArgs e)
		{
//			e.Value = cache.RetrieveElement(e.RowIndex, e.ColumnIndex);
		}

        protected string GetSelectedRowsText(bool copyColumnName, bool copyColumnType)
        {
            StringBuilder result = new StringBuilder("");
            int maxColumn = _dataGridView.ColumnCount;
            if (copyColumnName)
            {
                foreach (DataGridViewColumn column in GridView.Columns)
                {
                    if (column.Index > 0)
                    {
                        result.Append("\t");
                    }
                    result.Append(column.Name);
                }
                result.Append("\r\n");
            }
            if (copyColumnType && GridView.Columns[0].Tag != null)
            {
                foreach (DataGridViewColumn column in GridView.Columns)
                {
                    if (column.Index > 0)
                    {
                        result.Append("\t");
                    }
                    DatabaseColumn column2 = (DatabaseColumn)column.Tag;
                    result.Append(column2.TypeAndSize);
                    if (!column2.IsNullable)
                    {
                        result.Append("*");
                    }
                }
                result.Append("\r\n");
            }

            List<int> rowIndexList = new List<int>();
            foreach (DataGridViewRow row in _dataGridView.SelectedRows)
            {
                if (row.IsNewRow)
                {
                    continue;
                }
                rowIndexList.Add(row.Index);
            }
            rowIndexList.Sort();
            foreach (int rowNum in rowIndexList)
            {
                DataGridViewRow row = _dataGridView.Rows[rowNum];
                foreach (DataGridViewCell cell in row.Cells)
                {
                    if (cell.ColumnIndex > 0)
                    {
                        result.Append("\t");
                    }
                    object value = cell.Value;
                    if (value != null)
                    {
                        result.Append(cell.Value.ToString());
                    }
                }
                result.Append("\r\n");
            }
            return result.ToString();
        }

        private void _copyWithColumnMenuItem_Click(object sender, EventArgs e)
        {
            StringBuilder result = new StringBuilder("");
            if (_dataGridView.SelectedRows.Count > 0)
            {
                result.Append(GetSelectedRowsText(true, false));
            }
            else if (_dataGridView.SelectedCells.Count == 1)
            {
                object value = _dataGridView.SelectedCells[0].Value;
                if (value != null)
                {
                    result.Append(value.ToString());
                }
            }
            if (result.Length > 0)
            {
                Clipboard.SetText(result.ToString());
            }
            else
            {
                Clipboard.Clear();
            }
        }

        private void _copyWithTypeMenuItem_Click(object sender, EventArgs e)
        {
            StringBuilder result = new StringBuilder("");
            if (_dataGridView.SelectedRows.Count > 0)
            {
                result.Append(GetSelectedRowsText(true, true));
            }
            else if (_dataGridView.SelectedCells.Count == 1)
            {
                object value = _dataGridView.SelectedCells[0].Value;
                if (value != null)
                {
                    result.Append(value.ToString());
                }
            }
            if (result.Length > 0)
            {
                Clipboard.SetText(result.ToString());
            }
            else
            {
                Clipboard.Clear();
            }
        }

        private void _dataGridView_DataBindingComplete(object sender, DataGridViewBindingCompleteEventArgs e)
        {
            ProgramUtility.WriteLine("_dataGridView_DataBindingComplete");
            _cellEdit = true;
            //try
            //{
            //    _executer.UpdateDataSet();
            //}
            //catch (DatabaseContextException dce)
            //{
            //    ProgramUtility.ShowError(dce);
            //}
        }

        private void _dataGridView_SelectionChanged(object sender, EventArgs e)
        {
            ProgramUtility.WriteLine("_dataGridView_SelectionChanged");

            //if (_cellEdit)
            //{
            //    _cellEdit = false;

            //    _dataGridView.EndEdit();
            //    try
            //    {
            //        _executer.UpdateDataSet();
            //    }
            //    catch (DatabaseContextException dce)
            //    {
            //        ProgramUtility.ShowError(dce);
            //    }
            //}

        }

        private void _dataGridView_RowLeave(object sender, DataGridViewCellEventArgs e)
        {
            ProgramUtility.WriteLine("_dataGridView_RowLeave");
            //if (_executer.Table.Rows.Count > e.RowIndex && _executer.Table.Rows[e.RowIndex].HasErrors)
            //{
            //    _cellEdit = true;
            //}
//            if(_dataGridView.Rows[e.RowIndex].DuState == DataGridViewElementStates.
            //if (_rowEdit)
            //{
            //    if (_dataGridView.CurrentRow != null)
            //    {
            //        object currentRowView = (object)_dataGridView.CurrentRow.DataBoundItem;
            //        if (currentRowView is DataRowView)
            //        {
            //            ((DataRowView)currentRowView).EndEdit();
            //        }
            //    }
            //    _dataGridView.EndEdit();
            //    try
            //    {
            //        _executer.UpdateDataSet();
            //    }
            //    catch (DatabaseContextException dce)
            //    {
            //        ProgramUtility.ShowError(dce);
            //    }
            //}
        }
	}

	//private Cache memoryCache;

	//private string connectionString =
	//    "Initial Catalog=NorthWind;Data Source=localhost;" +
	//    "Integrated Security=SSPI;Persist Security Info=False";
	//private string table = "Orders";

	//protected override void OnLoad(EventArgs e)
	//{
	//    //// Initialize the form.
	//    //this.AutoSize = true;
	//    //this.Controls.Add(this.dataGridView1);
	//    //this.Text = "DataGridView virtual-mode just-in-time demo";

	//    //// Complete the initialization of the DataGridView.
	//    //this.dataGridView1.Size = new Size(800, 250);
	//    //this.dataGridView1.Dock = DockStyle.Fill;
	//    //this.dataGridView1.VirtualMode = true;
	//    //this.dataGridView1.ReadOnly = true;
	//    //this.dataGridView1.AllowUserToAddRows = false;
	//    //this.dataGridView1.AllowUserToOrderColumns = false;
	//    //this.dataGridView1.SelectionMode =
	//    //    DataGridViewSelectionMode.FullRowSelect;
	//    //this.dataGridView1.CellValueNeeded += new
	//    //    DataGridViewCellValueEventHandler(dataGridView1_CellValueNeeded);

	//    // Create a DataRetriever and use it to create a Cache object
	//    // and to initialize the DataGridView columns and rows.
	//    try
	//    {
	//        DataRetriever retriever =
	//            new DataRetriever(connectionString, table);
	//        memoryCache = new Cache(retriever, 16);
	//        foreach (DataColumn column in retriever.Columns)
	//        {
	//            dataGridView1.Columns.Add(
	//                column.ColumnName, column.ColumnName);
	//        }
	//        this.dataGridView1.RowCount = retriever.RowCount;
	//    }
	//    catch (SqlException)
	//    {
	//        MessageBox.Show("Connection could not be established. " +
	//            "Verify that the connection string is valid.");
	//        Application.Exit();
	//    }

	//    // Adjust the column widths based on the displayed values.
	//    this.dataGridView1.AutoResizeColumns(
	//        DataGridViewAutoSizeColumnsMode.DisplayedCells);

	//    base.OnLoad(e);
	//}

	//private void dataGridView1_CellValueNeeded(object sender,
	//    DataGridViewCellValueEventArgs e)
	//{
	//    e.Value = memoryCache.RetrieveElement(e.RowIndex, e.ColumnIndex);
	//}

	public interface IDataPageRetriever
	{
		DataTable SupplyPageOfData(int lowerPageBoundary, int rowsPerPage);
	}

	public class DataRetriever : IDataPageRetriever
	{
		private string tableName;
		private DbCommand command;
		protected DatabaseContextCommon _database;

		public DataRetriever(DatabaseContextCommon database, string tableName)
		{
//			SqlConnection connection = new SqlConnection(connectionString);
//			connection.Open();
			command = database.CreateCommand("SELECT * FROM " + tableName);
//			command = connection.CreateCommand();
			this.tableName = tableName;
			_database = database;
		}

		private int rowCountValue = -1;

		public int RowCount
		{
			get
			{
				// Return the existing value if it has already been determined.
				if (rowCountValue != -1)
				{
					return rowCountValue;
				}

				// Retrieve the row count from the database.
				command.CommandText = "SELECT COUNT(*) FROM " + tableName;
				rowCountValue = (int)command.ExecuteScalar();
				return rowCountValue;
			}
		}

		private DataColumnCollection columnsValue;

		public DataColumnCollection Columns
		{
			get
			{
				// Return the existing value if it has already been determined.
				if (columnsValue != null)
				{
					return columnsValue;
				}

				// Retrieve the column information from the database.
				command.CommandText = "SELECT * FROM " + tableName;
				//SqlDataAdapter adapter = new SqlDataAdapter();
				DbDataAdapter adapter = _database.CreateDataAdapter();
				adapter.SelectCommand = command;
				DataTable table = new DataTable();
				table.Locale = System.Globalization.CultureInfo.InvariantCulture;
				adapter.FillSchema(table, SchemaType.Source);
				columnsValue = table.Columns;
				return columnsValue;
			}
		}

		private string commaSeparatedListOfColumnNamesValue = null;

		private string CommaSeparatedListOfColumnNames
		{
			get
			{
				// Return the existing value if it has already been determined.
				if (commaSeparatedListOfColumnNamesValue != null)
				{
					return commaSeparatedListOfColumnNamesValue;
				}

				// Store a list of column names for use in the
				// SupplyPageOfData method.
				System.Text.StringBuilder commaSeparatedColumnNames =
					new System.Text.StringBuilder();
				bool firstColumn = true;
				foreach (DataColumn column in Columns)
				{
					if (!firstColumn)
					{
						commaSeparatedColumnNames.Append(", ");
					}
					commaSeparatedColumnNames.Append(column.ColumnName);
					firstColumn = false;
				}

				commaSeparatedListOfColumnNamesValue =
					commaSeparatedColumnNames.ToString();
				return commaSeparatedListOfColumnNamesValue;
			}
		}

		// Declare variables to be reused by the SupplyPageOfData method.
		private string columnToSortBy;
		//private DbDataAdapter adapter = new DbDataAdapter();
		private DbDataAdapter adapter;

		public DataTable SupplyPageOfData(int lowerPageBoundary, int rowsPerPage)
		{
			// Store the name of the ID column. This column must contain unique 
			// values so the SQL below will work properly.
			if (columnToSortBy == null)
			{
				columnToSortBy = this.Columns[0].ColumnName;
			}

			if (!this.Columns[columnToSortBy].Unique)
			{
				throw new InvalidOperationException(String.Format(
					"Column {0} must contain unique values.", columnToSortBy));
			}

			// Retrieve the specified number of rows from the database, starting
			// with the row specified by the lowerPageBoundary parameter.
			command.CommandText = "Select Top " + rowsPerPage + " " +
				CommaSeparatedListOfColumnNames + " From " + tableName +
				" WHERE " + columnToSortBy + " NOT IN (SELECT TOP " +
				lowerPageBoundary + " " + columnToSortBy + " From " +
				tableName + " Order By " + columnToSortBy +
				") Order By " + columnToSortBy;
			adapter = _database.CreateDataAdapter();
			adapter.SelectCommand = command;

			DataTable table = new DataTable();
			table.Locale = System.Globalization.CultureInfo.InvariantCulture;
			adapter.Fill(table);
			return table;
		}

	}

	public class Cache
	{
		private static int RowsPerPage;

		// Represents one page of data.  
		public struct DataPage
		{
			public DataTable table;
			private int lowestIndexValue;
			private int highestIndexValue;

			public DataPage(DataTable table, int rowIndex)
			{
				this.table = table;
				lowestIndexValue = MapToLowerBoundary(rowIndex);
				highestIndexValue = MapToUpperBoundary(rowIndex);
				System.Diagnostics.Debug.Assert(lowestIndexValue >= 0);
				System.Diagnostics.Debug.Assert(highestIndexValue >= 0);
			}

			public int LowestIndex
			{
				get
				{
					return lowestIndexValue;
				}
			}

			public int HighestIndex
			{
				get
				{
					return highestIndexValue;
				}
			}

			public static int MapToLowerBoundary(int rowIndex)
			{
				// Return the lowest index of a page containing the given index.
				return (rowIndex / RowsPerPage) * RowsPerPage;
			}

			private static int MapToUpperBoundary(int rowIndex)
			{
				// Return the highest index of a page containing the given index.
				return MapToLowerBoundary(rowIndex) + RowsPerPage - 1;
			}
		}

		private DataPage[] cachePages;
		private IDataPageRetriever dataSupply;

		public Cache(IDataPageRetriever dataSupplier, int rowsPerPage)
		{
			dataSupply = dataSupplier;
			Cache.RowsPerPage = rowsPerPage;
			LoadFirstTwoPages();
		}

		// Sets the value of the element parameter if the value is in the cache.
		private bool IfPageCached_ThenSetElement(int rowIndex,
			int columnIndex, ref string element)
		{
			if (IsRowCachedInPage(0, rowIndex))
			{
				element = cachePages[0].table
					.Rows[rowIndex % RowsPerPage][columnIndex].ToString();
				return true;
			}
			else if (IsRowCachedInPage(1, rowIndex))
			{
				element = cachePages[1].table
					.Rows[rowIndex % RowsPerPage][columnIndex].ToString();
				return true;
			}

			return false;
		}

		public string RetrieveElement(int rowIndex, int columnIndex)
		{
			string element = null;

			if (IfPageCached_ThenSetElement(rowIndex, columnIndex, ref element))
			{
				return element;
			}
			else
			{
				return RetrieveData_CacheIt_ThenReturnElement(
					rowIndex, columnIndex);
			}
		}

		private void LoadFirstTwoPages()
		{
			cachePages = new DataPage[]{
				new DataPage(dataSupply.SupplyPageOfData(
					DataPage.MapToLowerBoundary(0), RowsPerPage), 0), 
				new DataPage(dataSupply.SupplyPageOfData(
					DataPage.MapToLowerBoundary(RowsPerPage), 
					RowsPerPage), RowsPerPage)};
		}

		private string RetrieveData_CacheIt_ThenReturnElement(
			int rowIndex, int columnIndex)
		{
			// Retrieve a page worth of data containing the requested value.
			DataTable table = dataSupply.SupplyPageOfData(
				DataPage.MapToLowerBoundary(rowIndex), RowsPerPage);

			// Replace the cached page furthest from the requested cell
			// with a new page containing the newly retrieved data.
			cachePages[GetIndexToUnusedPage(rowIndex)] = new DataPage(table, rowIndex);

			return RetrieveElement(rowIndex, columnIndex);
		}

		// Returns the index of the cached page most distant from the given index
		// and therefore least likely to be reused.
		private int GetIndexToUnusedPage(int rowIndex)
		{
			if (rowIndex > cachePages[0].HighestIndex &&
				rowIndex > cachePages[1].HighestIndex)
			{
				int offsetFromPage0 = rowIndex - cachePages[0].HighestIndex;
				int offsetFromPage1 = rowIndex - cachePages[1].HighestIndex;
				if (offsetFromPage0 < offsetFromPage1)
				{
					return 1;
				}
				return 0;
			}
			else
			{
				int offsetFromPage0 = cachePages[0].LowestIndex - rowIndex;
				int offsetFromPage1 = cachePages[1].LowestIndex - rowIndex;
				if (offsetFromPage0 < offsetFromPage1)
				{
					return 1;
				}
				return 0;
			}

		}

		// Returns a value indicating whether the given row index is contained
		// in the given DataPage. 
		private bool IsRowCachedInPage(int pageNumber, int rowIndex)
		{
			return rowIndex <= cachePages[pageNumber].HighestIndex &&
				rowIndex >= cachePages[pageNumber].LowestIndex;
		}
	}
}

