using System;
using System.Collections.Generic;
using System.Text;
using System.Data.Common;
using System.Data.Odbc;

namespace Oratorio
{
    public class DatabaseContextOdbcMsSqlServer : DatabaseContextOdbc
    {
        public override string ProductName
        {
            get { return "SQL Server"; }
        }

        public override bool AllowDatabaseChange
        {
            get { return true; }
        }

        public DatabaseContextOdbcMsSqlServer(OdbcConnection connection)
            : base(connection)
        {
            _productType = ProductTypes.MsSqlServer;
            _currentCatalogName = connection.Database;
        }
        public override string[] GetSchemaList()
        {
            DbCommand command2 = Connection.CreateCommand();
            command2.CommandText = "SELECT * FROM information_schema.schemata ORDER BY schema_name";
            try
            {
                DbDataReader reader2 = command2.ExecuteReader();
                List<string> resultList = new List<string>();
                while (reader2.Read())
                {
                    resultList.Add(reader2.GetString(1));
                }
                return resultList.ToArray();
            }
            catch (InvalidOperationException ioe)
            {
                throw new DatabaseContextException("Get schema list failed.", ioe);
            }
        }
        public override string GetCurrentSchema()
        {
            try
            {
                DbCommand command2 = Connection.CreateCommand();
                command2.CommandText = "SELECT name FROM sys.schemas WHERE schema_id = schema_id()";
                DbDataReader reader2 = command2.ExecuteReader();
                if (!reader2.Read())
                {
                    throw new NotSupportedException();
                }
                _currentSchemaName = reader2.GetString(0);
                return _currentSchemaName;
            }
            catch (DbException dbe)
            {
                throw new DatabaseContextException("XL[}̎擾Ɏs܂B", dbe);
            }
        }

        //public override string GetOdbcTypeName(OdbcType type)
        //{
        //    switch(type)
        //    {
        //        case ((OdbcType)(-9)):
        //            return "DECIMAL";
        //        case ((OdbcType)93):
        //            return "VARCHAR";
        //    }
        //    return base.GetOdbcTypeName(type);
        //}


        public override void GetTableColumnList(string catalog, string schema, string tableName, List<DatabaseColumn> list)
        {
            if (tableName == null)
            {
                throw new ArgumentNullException("tableName");
            }
            base.GetTableColumnList(null, schema, tableName, list);
            Dictionary<string, DatabaseColumn> columnDict = new Dictionary<string, DatabaseColumn>();
            foreach (DatabaseColumn col in list)
	        {
                columnDict.Add(col.ColumnName, col);
	        }

            try
            {
                string sQuery =
                    " SELECT\r\n" +
                    " 	syscolumns.name\r\n" +
                    " FROM\r\n" +
                    " 	sysindexes,\r\n" +
                    " 	sysobjects,\r\n" +
                    " 	sysindexkeys,\r\n" +
                    " 	syscolumns\r\n" +
                    " WHERE\r\n" +
                    " sysobjects.name = ?\r\n" +
                    " AND sysindexes.id = sysobjects.id\r\n" +
                    " AND sysindexes.indid = 1\r\n" +
                    " AND sysindexkeys.id = sysobjects.id\r\n" +
                    " AND sysindexkeys.indid = sysindexes.indid\r\n" +
                    " AND syscolumns.id = sysobjects.id\r\n" +
                    " AND syscolumns.colid = sysindexkeys.colid\r\n" +
                    " ORDER BY\r\n" +
                    " 	keyno\r\n";
                DbCommand command1 = CreateCommand(sQuery);
                command1.Parameters.Add(CreateParameter(null, tableName));
                DbDataReader reader1 = command1.ExecuteReader();

                Dictionary<string, DatabaseColumn> indexList = new Dictionary<string, DatabaseColumn>();
                while (reader1.Read())
                {
                    string name = reader1.GetString(0);
                    if (columnDict.ContainsKey(name))
                    {
                        columnDict[name].IsKey = true;
                    }
                }
            }
            catch (DbException dbe)
            {
                throw new DatabaseContextException("̎擾Ɏs܂B", dbe);
            }
            catch (InvalidOperationException ioex)
            {
                throw new DatabaseContextException("̎擾Ɏs܂B", ioex);
            }
        }

        public override string[] GetDatabaseList()
        {
            try
            {
                string sQuery =
                    " SELECT\r\n" +
                    " 	name\r\n" +
                    " FROM\r\n" +
                    " 	sys.sysdatabases\r\n" +
                    " ORDER BY\r\n" +
                    " 	name\r\n";
                DbCommand command1 = CreateCommand(sQuery);
                DbDataReader reader1 = command1.ExecuteReader();

                List<string> dbList = new List<string>();
                while (reader1.Read())
                {
                    string name = reader1.GetString(0);
                    dbList.Add(name);
                }
                return dbList.ToArray();
            }
            catch (DbException dbe)
            {
                throw new DatabaseContextException("̎擾Ɏs܂B", dbe);
            }
            catch (InvalidOperationException ioex)
            {
                throw new DatabaseContextException("̎擾Ɏs܂B", ioex);
            }
        }

        public override void ChangeDatabase(string databaseName)
        {
            try
            {
                DbCommand command = CreateCommand("USE " + databaseName);
                command.ExecuteNonQuery();
            }
            catch (DbException dbe)
            {
                throw new DatabaseContextException("Change database failed.", dbe);
            }
            _currentCatalogName = databaseName;
        }
    }
}
