using System;
using System.Collections.Generic;
using System.Text;
using System.Data.Common;
using System.Data.Odbc;

namespace Oratorio
{
    public class DatabaseContextOdbcMySql : DatabaseContextOdbc
    {
        private bool _versionUnder5;

        public override string ProductName
        {
            get { return "MySQL"; }
        }

        public DatabaseContextOdbcMySql(OdbcConnection connection)
            : base(connection)
        {
            _productType = ProductTypes.MySql;
            _connection = connection;

            try
            {
                string query = "SELECT SCHEMA()";
                using (DbDataReader reader = CreateCommand(query).ExecuteReader())
                {
                }
            }
            catch (OdbcException)
            {
                _versionUnder5 = true;
            }
            
            //try
			//{
			//    DbCommand command2 = Connection.CreateCommand();
			//    command2.CommandText = "SELECT SCHEMA()";
			//    DbDataReader reader2 = command2.ExecuteReader();
			//    if (reader2.Read())
			//    {
			//        _currentSchemaName  = reader2.GetString(0);
			//    }
			//    _currentCatalogName = connection.Database;
			//}
			//catch (DbException dbe)
			//{
			//    throw new DatabaseContextException("XL[}̎擾Ɏs܂B", dbe);
			//}
        }
		public override string GetCurrentSchema()
		{
            try
            {
                string query = "SELECT SCHEMA()";
                using (DbDataReader reader = CreateCommand(query).ExecuteReader())
                {
                    if (!reader.Read())
                    {
                        throw new NotSupportedException();
                    }
                    _currentSchemaName = reader.GetString(0);
                }
                return _currentSchemaName;
            }
            catch (OdbcException)
            {
                return "";
            }
		}

        public override string[] GetTableList(string catalog, string schema)
        {
            if (!_versionUnder5)
            {
                return base.GetTableList(catalog, schema);
            }
            string query = "SHOW TABLES";
            DbCommand command = CreateCommand(query);
            if (schema != _currentSchemaName)
            {
                command.Parameters.Add(CreateParameter("1", schema));
            }
            List<string> aList = new List<string>();
            using (DbDataReader reader = command.ExecuteReader())
            {
                while (reader.Read())
                {
                    aList.Add(reader.GetString(0));
                }
            }
            return aList.ToArray();
        }

        public override DatabaseTable[] GetTableList2(string catalog, string schema)
        {
            return base.GetTableList2(null, null);
        }

        public override bool IsDateType(string typeName)
        {
            return typeName == "date";
        }
    }
}
