using System;
using System.Collections.Generic;
using System.Text;
using System.Data.Common;
using System.Data.Odbc;
using System.Data;

namespace Oratorio
{
    public class DatabaseContextOdbcOracle : DatabaseContextOdbc
    {
        public override string ProductName
        {
            get { return "Oracle"; }
        }

        public DatabaseContextOdbcOracle(OdbcConnection connection)
            : base(connection)
        {
            _productType = ProductTypes.Oracle;
//            _currentCatalogName = _currentSchemaName;
            //            _currentCatalogName = null;
            _currentCatalogName = "";
            _scriptGenerator = new DatabaseScriptGeneratorOracle(this);
            _currentDatabaseName = GetDatabaseName();
        }

        public string GetDatabaseName()
        {
            string query = "select name from v$database";
            using (DbDataReader reader = CreateCommand(query).ExecuteReader())
            {
				if(reader.Read())
				{
					return reader.GetString(0);
				}
            }
            return null;
        }

        public override string[] GetSchemaList()
        {
            string query = "SELECT username FROM all_users ORDER BY username";
            List<string> aList = new List<string>();
            using (DbDataReader reader = CreateCommand(query).ExecuteReader())
            {
				while (reader.Read())
				{
					aList.Add(reader.GetString(0));
				}
            }
            return aList.ToArray();
        }

        public override string GetCurrentSchema()
        {
            string query = "SELECT USER FROM DUAL";
            //using (DbDataReader reader = CreateCommand(query).ExecuteReader())
            //{
            //    if (!reader.Read())
            //    {
            //        throw new NotSupportedException();
            //    }
            //    _currentSchemaName = reader.GetString(0);
            //}
            using (DbCommand command = CreateCommand(query))
            {
                using (DbDataReader reader = command.ExecuteReader())
                {
                    if (!reader.Read())
                    {
                        throw new NotSupportedException();
                    }
                    _currentSchemaName = reader.GetString(0);
                }
            }
            return _currentSchemaName;
        }
        
        public override string[] GetTableList(string catalog, string schema)
        {
            return base.GetTableList(null, schema);
        }

        public override string[] GetViewList(string catalog, string schema)
        {
            return base.GetViewList(null, schema);
        }
        public override DatabaseObjectIndex[] GetIndexList(string catalog, string schema, string tableName)
        {
            return base.GetIndexList(null, schema, tableName);
        }

        public override void GetTableColumnList(string catalog, string schema, string tableName, List<DatabaseColumn> list)
        {
            if (tableName == null)
            {
                throw new ArgumentNullException("tableName");
            }
            //if (true)
            //{
            //    base.GetTableColumnList(null, schema, tableName, list);
            //    return;
            //}
            bool sameSchema = (schema == null || schema == _currentSchemaName);

            try
            {
                string sQuery =
                    "	SELECT " +
                    "		NULL, " +
                    "		NULL, " +
                    "		table_name, " +
                    "		column_name, " +
                    "		NULL, " +
                    "		data_type type_name, " +
                    "		data_length column_size, " +
                    "		NULL, " +
                    "		data_scale decimal_digits, " +
                    "		data_precision num_prec_radix, " +
                    "		nullable, " +
                    "		NULL, " +
                    "		data_default" +
                    "	FROM " +
                    "		user_tab_columns " +
                    "	WHERE " +
                    "		table_name = ?" +
                    "	ORDER BY column_id ";
                if (!sameSchema)
                {
                    //sQuery =
                    //    "	SELECT " +
                    //    "		NULL, " +
                    //    "		NULL, " +
                    //    "		table_name, " +
                    //    "		column_name, " +
                    //    "		data_type, " +
                    //    "		DECODE(data_precision, NULL, '' || data_length, '' || data_precision || ',' || data_scale) type_length, " +
                    //    "		NULL, " +
                    //    "		nullable, " +
                    //    "		NULL, " +
                    //    "		data_default" +
                    //    "	FROM " +
                    //    "		all_tab_columns " +
                    //    "	WHERE " +
                    //    "		owner = ?" +
                    //    "		AND table_name = ?" +
                    //    "	ORDER BY column_id ";
                    sQuery =
                        "	SELECT " +
                        "		NULL, " +
                        "		NULL, " +
                        "		table_name, " +
                        "		column_name, " +
                        "		NULL, " +
                        "		data_type type_name, " +
                        "		data_length column_size, " +
                        "		NULL, " +
                        "		data_scale decimal_digits, " +
                        "		data_precision num_prec_radix, " +
                        "		nullable, " +
                        "		NULL, " +
                        "		data_default" +
                        "	FROM " +
                        "		all_tab_columns " +
                        "	WHERE " +
                        "		owner = ?" +
                        "		AND table_name = ?" +
                        "	ORDER BY column_id ";
                }
                DbCommand command1 = CreateCommand(sQuery);
                if (!sameSchema)
                {
                    command1.Parameters.Add(CreateParameter(null, schema));
                }
                command1.Parameters.Add(CreateParameter(null, tableName));
                DbDataReader reader1 = command1.ExecuteReader();

                Dictionary<string, DatabaseColumn> indexList = new Dictionary<string, DatabaseColumn>();
                int index = 0;
                while (reader1.Read())
                {
                    DatabaseColumn column = new DatabaseColumn();
                    column.Index = index++;
                    column.ColumnName = reader1.GetString(3);
                    column.TypeName = reader1.GetString(5);
                    column.TypeAndSize = column.TypeName;
                    //TODO
                    if (column.TypeName.IndexOf("CHAR") >= 0)
                    {
                        column.TypeAndSize += "(" + reader1.GetString(6) + ")";
                    }
                    else if (column.TypeName.IndexOf("NUMBER") >= 0)
                    {
                        string decimalDigits = "";
                        if (!reader1.IsDBNull(8))
                        {
                            decimalDigits = reader1.GetDouble(8).ToString();
                        }
                        string dataPrecision = "";
                        if (!reader1.IsDBNull(9))
                        {
                            dataPrecision = reader1.GetDouble(9).ToString();
                        }
                        if (dataPrecision.Length != 0 && (dataPrecision != "22" || decimalDigits != "0"))
                        {
                            if (decimalDigits != "" && decimalDigits != "0")
                            {
                                decimalDigits = ", " + decimalDigits;
                            }
                            else
                            {
                                decimalDigits = "";
                            }
                            column.TypeAndSize += "(" + dataPrecision + decimalDigits + ")";
                        }
                    }
                    string nullable = reader1.GetString(10);
                    column.IsNullable = (nullable == "Y");
                    list.Add(column);
                    indexList.Add(column.ColumnName, column);
                }

                string sQuery2 =
                    "	SELECT ucc.column_name " +
                    "	FROM " +
                    "		user_constraints ucs, " +
                    "		user_cons_columns ucc " +
                    "	WHERE " +
                    "	ucs.table_name = ? " +
                    "	AND ucs.constraint_type = 'P' " +
                    "	AND ucc.table_name = ucs.table_name " +
                    "	AND ucc.constraint_name = ucs.constraint_name " +
                    "	ORDER BY ucc.position ";
                if (!sameSchema)
                {
                    sQuery2 =
                        "	SELECT ucc.column_name " +
                        "	FROM " +
                        "		all_constraints ucs, " +
                        "		all_cons_columns ucc " +
                        "	WHERE " +
                        "	ucs.owner = ? " +
                        "	AND ucs.table_name = ? " +
                        "	AND ucs.constraint_type = 'P' " +
                        "	AND ucc.owner = ucs.owner " +
                        "	AND ucc.table_name = ucs.table_name " +
                        "	AND ucc.constraint_name = ucs.constraint_name " +
                        "	ORDER BY ucc.position ";
                }
                DbCommand command2 = CreateCommand(sQuery2);
                if (!sameSchema)
                {
                    command2.Parameters.Add(CreateParameter(null, schema));
                }
                command2.Parameters.Add(CreateParameter(null, tableName));
                DbDataReader reader2 = command2.ExecuteReader();
                while (reader2.Read())
                {
                    string columnName = reader2.GetString(0);
                    indexList[columnName].IsKey = true;
                }
            }
            catch (DbException dbe)
            {
                throw new DatabaseContextException("̎擾Ɏs܂B", dbe);
            }
            catch (InvalidOperationException ioex)
            {
                throw new DatabaseContextException("̎擾Ɏs܂B", ioex);
            }
        }

        public override string[] GetProcedureList(string catalog, string schema)
        {
            return base.GetProcedureList(null, schema);
        }


	}
}
